Option Explicit
Option Base 1

'Win SDK calls and Consts
Global Const ATTR_NORMAL = 0

Global Const NAMESIZE = 9
Global Const PWSIZE = 10
Global Const DSCRSIZE = 25
Global Const SERLEN = 15
Global Const ENTRYSIZE = 128
Global Const FILLSIZE = 37
Global Const NETDIR_RECORDSIZE = 128

Global Const NAMEAPPS = 5

'User-defined types

Type HdrEntry
    e_etype As String * 1
    s_conz As String * 1
    s_hname As String * NAMESIZE
    s_hpass As String * PWSIZE
    s_hfull As String * DSCRSIZE
    s_admin As String * NAMESIZE
    s_print As String * NAMESIZE
    s_modem As String * NAMESIZE
    s_sport As String * 2
    s_notinw As String * 1
    s_entprs As String * NAMESIZE
    s_padl As String * 3
    s_htype As String * 1
    s_prhub As String * NAMESIZE
    s_baud As String * 2
    s_serial As String * SERLEN
    s_niocal As String * 2
    s_version As String * 1
    s_netw As String * NAMESIZE
    s_nopthr As String * 1
End Type

Type NameEntry
    e_etype As String * 1
    e_name As String * NAMESIZE
    n_fullname As String * DSCRSIZE
    n_password As String * PWSIZE
    n_netident As String * 1
    n_apps(5) As String * NAMESIZE
    n_fill As String * FILLSIZE
End Type



Type ApplEntry
    e_etype As String * 1
    e_name As String * NAMESIZE
    a_fullname As String * DSCRSIZE
    a_password As String * PWSIZE
    a_qtyusers As String * 2
    a_maxusers As String * 2
    a_vercntrl As String * 1
    a_mgmtcntrl As String * 1
    a_fill As String * 77
End Type

Type USER_INFO
    connNumber As Integer
    objectName As String * 48
    objectType As Integer
    objectID As Long
    loginTime As String * 7
End Type

'Global variables used with NOTIFY
Global serverPath As String
Global MHSDirectory As String
Global userApplication As String
Global gScanNext As Integer
Global gSubjectText As String
Global gFromText As String
Global gDateText As String

'NWCALLS.DLL function prototypes
Declare Function NWGetFileServerName Lib "NWCALLS.DLL" (ByVal conn As Integer, ByVal serverName As String) As Integer
Declare Function NWGetConnectionHandle Lib "NWCALLS.DLL" (ByVal serverName As String, ByVal reserver1 As Integer, conn As Integer, reserved2 As Any) As Integer
Declare Function NWGetDefaultConnectionID Lib "NWCALLS.DLL" (conn As Integer) As Integer
Declare Function NWCallsInit Lib "NWCALLS.DLL" (ByVal in&, ByVal out&) As Integer
Declare Function NWGetFileServerInformation Lib "NWCALLS.DLL" (ByVal conn As Integer, serverName As Any, majVer As Any, minVer As Any, rev As Any, maxConn As Any, maxConnUsed As Any, maxConnsInuse As Any, numVol As Any, sft As Any, tts As Any) As Integer
Declare Function NWGetConnectionInformation Lib "NWCALLS.DLL" (ByVal conn As Integer, ByVal connNumber As Integer, objectName As Any, objectType As Any, objectID As Any, loginTime As Any) As Integer
Declare Function NWGetConnectionNumber Lib "NWCALLS.DLL" (ByVal conn As Integer, connNumber As Integer) As Integer

Sub DisplaySubjects ()
    
    Dim DirName As String
    Dim TextFile As String
    Dim FileNum As Integer
    Dim count As Integer

    'Scan the user's application directory for new messages
    gScanNext = True
    DirName = Dir$(MHSDirectory, ATTR_NORMAL) ' Get first file name.
    Do While gScanNext And DirName <> ""
        FileNum = FreeFile

        Open MHSDirectory & DirName For Input As FileNum   ' Open file.

        TextFile = ReadLine(FileNum)

        'If we have the Signature
        If Left$(TextFile, 6) = "SMF-71" Then
            Do While Not EOF(FileNum)
                TextFile = ReadLine(FileNum)
    
                'Check for the fields of interest
                If Left$(TextFile, 5) = "Date:" Then
                    gDateText = Mid$(TextFile, 7, 25)
                End If

                If Left$(TextFile, 5) = "From:" Then
                    gFromText = Mid$(TextFile, 7, 25)
                End If

                If Left$(TextFile, 8) = "Subject:" Then
                    gSubjectText = Mid$(TextFile, 10, 25)
                End If
            Loop
            
            'Hide the notify window
            'and show the header window
            Notify.Visible = False
            Message.Show 1
        End If

        Close FileNum
        DirName = Dir$   ' Get another file name.
    Loop

    Notify.Visible = True
    Unload Message
End Sub

Function GetMHSDirectory (user As String) As String

    Dim ccode As Integer
    Dim connID As Integer
    Dim connNum As Integer
    Dim tokNum As Integer
    Dim nwUser As USER_INFO
    Dim mailPath As String
    'Dim user As String
    Dim userPath As String
    Dim server As String
    Dim serverName As String * 48

    'Initialize NWCALLS
    ccode = NWCallsInit(ByVal 0&, ByVal 0&)

    'Get the default connection id and connection number
    ccode = NWGetDefaultConnectionID(connID)
    
    ccode = NWGetConnectionNumber(connID, connNum)
    
    'Get the user's login name
    ccode = NWGetConnectionInformation(connID, connNum, ByVal nwUser.objectName, nwUser.objectType, nwUser.objectID, ByVal nwUser.loginTime)

    user = nwUser.objectName
    NullStrip user

    'If we have the MV environment variable, use it
    mailPath = Environ$("MV")
    
    If Len(mailPath) > 0 Then
        userPath = mailPath

    Else
    'Otherwise get the server on the default connection
    'and the SYS volume and create a UNC path with it
        ccode = NWGetFileServerName(connID, serverName)
        NullStrip (serverName)
        userPath = "\\" & server & "\SYS"
    End If

    GetMHSDirectory = userPath

End Function

Sub NullStrip (inString As String)
'Strip off the NULLs at the end of the string
    Dim nullNum As Integer

    nullNum = InStr(inString, Chr$(0))
    If (nullNum > 0) Then
        inString = Left$(inString, nullNum - 1)
    Else
        inString = Chr$(0)
    End If

End Sub

Function ReadLine (FileNum As Integer)
'Read characters from file until a linefeed occurs

    Dim Char, TextData    ' Declare variables.
    Do While Not EOF(FileNum)
        Char = Input(FileNum, #1) ' Get one character.
        If Char <> Chr(10) Then ' If not linefeed.
            TextData = TextData & Char
        Else    ' If linefeed,
            ReadLine = TextData
            Exit Function
        End If

    Loop    ' Loop if not end of file.

    ReadLine = TextData

End Function

Function ReadUserData (filePath As String, user As String, Application As String) As Integer
'Read from netdir.tab until we find a record with the user's name
'return the preferred application

    Dim FNum As Integer
    Dim userIndex, users As Integer
    Dim Msg As String
    Dim hdrRec As HdrEntry
    Dim nameRec As NameEntry
    Dim applRec As ApplEntry
    Dim inString As String * 128
    Dim userNums As String

    On Error GoTo ErrorHandler  ' Set up error handler.

    FNum = FreeFile ' Determine file number.
    Open filePath For Random Access Read As FNum Len = NETDIR_RECORDSIZE   ' Open file.
    Get FNum, 1, hdrRec

    If hdrRec.e_etype <> Chr$(0) Then
        MsgBox "NETDIR.TAB Header Record incorrect"
        Exit Function
    End If

    userIndex = Asc(Mid$(hdrRec.s_niocal, 1, 1)) + 10 * Asc(Mid$(hdrRec.s_niocal, 2, 1))
    For users = 1 To userIndex
        Get FNum, users + 1, inString

        'Record type 0x02 is user name
        If Left$(inString, 1) = Chr$(2) Then
            TranslateName inString, nameRec
            If StrComp(nameRec.e_name, user, 1) = 0 Then
                Application = nameRec.n_apps(1)
            End If
        'Record type 0x09 is application entry
        ElseIf Left$(inString, 1) = Chr$(9) Then
            TranslateAppl inString, applRec
        End If
    Next users

    Close FNum
    
    NullStrip Application
    
    Exit Function

ErrorHandler:   ' Error handler line label.

    Select Case Err
        'Case 53: Msg = "ERROR 53: That file doesn't exist."
        'Case 68: Msg = "ERROR 68: Drive " & Drive & ": not available."
        'Case 76: Msg = "ERROR 76: That path doesn't exist."
        Case Else: Msg = "ERROR " & Err & " occurred."
    End Select
    MsgBox Msg  ' Display error message.
    Resume Next ' Resume procedure.

End Function

Function ScanNewMail () As Integer
'Scan the user's mail directory for new messages
    Dim DirName As String
    Dim TextFile As String
    Dim FileNum As Integer
    Dim count As Integer

    DirName = Dir$(MHSDirectory, ATTR_NORMAL) ' Get first file name.
    Do While DirName <> ""
        FileNum = FreeFile

        Open MHSDirectory & DirName For Input As FileNum   ' Open file.

        TextFile = ReadLine(FileNum)

        'If we have the Signature, increment new message count
        If Left$(TextFile, 6) = "SMF-71" Then
            count = count + 1
        End If

        Close FileNum
        DirName = Dir$   ' Get another file name.
    Loop
    ScanNewMail = count

End Function

Sub TranslateAppl (inString As String, applRec As ApplEntry)
'Convert string to Application entry record

    applRec.e_etype = Mid$(inString, 1, 1)
    applRec.e_name = Mid$(inString, 2, NAMESIZE)
    applRec.a_fullname = Mid$(inString, 11, DSCRSIZE)
    applRec.a_password = Mid$(inString, 36, PWSIZE)
    applRec.a_qtyusers = Mid$(inString, 46, 2)
    applRec.a_maxusers = Mid$(inString, 48, 2)
    applRec.a_vercntrl = Mid$(inString, 50, 1)
    applRec.a_mgmtcntrl = Mid$(inString, 51, 1)
    applRec.a_fill = Mid$(inString, 77)

End Sub

Sub TranslateName (inString As String, nameRec As NameEntry)
'Convert string to name entry record

    nameRec.e_etype = Mid$(inString, 1, 1)
    nameRec.e_name = Mid$(inString, 2, NAMESIZE)
    nameRec.n_fullname = Mid$(inString, 11, DSCRSIZE)
    nameRec.n_password = Mid$(inString, 36, PWSIZE)
    nameRec.n_netident = Mid$(inString, 46, 1)
    nameRec.n_apps(1) = Mid$(inString, 47, NAMESIZE)
    nameRec.n_apps(2) = Mid$(inString, 56, NAMESIZE)
    nameRec.n_apps(3) = Mid$(inString, 65, NAMESIZE)
    nameRec.n_apps(4) = Mid$(inString, 74, NAMESIZE)
    nameRec.n_apps(5) = Mid$(inString, 83, NAMESIZE)
    nameRec.n_fill = Mid$(inString, 92, FILLSIZE)

End Sub

