// SOCK_IO.cpp
#define ACE_BUILD_DLL
#include "ace/SOCK_IO.h"

ACE_ALLOC_HOOK_DEFINE(ACE_SOCK_IO)

void
ACE_SOCK_IO::dump (void) const
{
  ACE_TRACE ("ACE_SOCK_IO::dump");
}

// Allows a client to read from a socket without having to provide
// a buffer to read.  This method determines how much data is in the
// socket, allocates a buffer of this size, reads in the data, and
// returns the number of bytes read.

ssize_t
ACE_SOCK_IO::recv (iovec *io_vec)
{
#if defined (FIONREAD)
  u_long inlen;

  if (ACE_OS::ioctl (this->get_handle (), FIONREAD,
                     (u_long *) &inlen) == -1)
    return -1;
  else if (inlen > 0)
    {
      io_vec->iov_base = new char[inlen];
      io_vec->iov_len = this->recv (io_vec->iov_base, inlen);
      return io_vec->iov_len;
    }
  else
#endif /* FIONREAD */
  // Could return ACE_NOTSUP_RETURN
    return 0; 
}

// Send N char *ptrs and int lengths.  Note that the char *'s precede
// the ints (basically, an varargs version of writev).  The count N is
// the *total* number of trailing arguments, *not* a couple of the
// number of tuple pairs!

ssize_t
ACE_SOCK_IO::send (size_t n, ...) const
{
  ACE_TRACE ("ACE_SOCK_IO::send");

  va_list argp;  
  size_t total_tuples = n / 2;
  ssize_t result;
#if defined (ACE_HAS_ALLOCA)
  iovec *iovp = (iovec *) alloca (total_tuples * sizeof (iovec));
#else 
  iovec *iovp;
  ACE_NEW_RETURN (iovp, iovec[total_tuples], -1);
#endif /* !defined (ACE_HAS_ALLOCA) */

  va_start (argp, n);

  for (size_t i = 0; i < total_tuples; i++)
    {
      iovp[i].iov_base = va_arg (argp, char *);
      iovp[i].iov_len  = va_arg (argp, int);
    }

  result = ACE_OS::writev (this->get_handle (), iovp, total_tuples);
#if !defined (ACE_HAS_ALLOCA)
  delete [] iovp;
#endif /* !defined (ACE_HAS_ALLOCA) */
  va_end (argp);
  return result;
}

// This is basically an interface to ACE_OS::readv, that doesn't use
// the struct iovec explicitly.  The ... can be passed as an arbitrary
// number of (char *ptr, int len) tuples.  However, the count N is the
// *total* number of trailing arguments, *not* a couple of the number
// of tuple pairs!

ssize_t
ACE_SOCK_IO::recv (size_t n, ...) const
{
  ACE_TRACE ("ACE_SOCK_IO::recv");

  va_list argp;  
  size_t  total_tuples = n / 2;
  ssize_t result;
#if defined (ACE_HAS_ALLOCA)
  iovec *iovp = (iovec *) alloca (total_tuples * sizeof (iovec));
#else
  iovec *iovp;
  
  ACE_NEW_RETURN (iovp, iovec[total_tuples], -1);
#endif /* !defined (ACE_HAS_ALLOCA) */

  va_start (argp, n);

  for (size_t i = 0; i < total_tuples; i++)
    {
      iovp[i].iov_base = va_arg (argp, char *);
      iovp[i].iov_len  = va_arg (argp, int);
    }

  result = ACE_OS::readv (this->get_handle (), iovp, total_tuples);
#if !defined (ACE_HAS_ALLOCA)
  delete [] iovp;
#endif /* !defined (ACE_HAS_ALLOCA) */
  va_end (argp);
  return result;
}

