/* -*- C++ -*- */

// ============================================================================
//
// = LIBRARY
//    ace
// 
// = FILENAME
//    System_Time.h
//
// = AUTHOR
//    Tim H. Harrison and Douglas C. Schmidt    
//
// ============================================================================

#if !defined (ACE_SYSTEM_TIME_H)
#define ACE_SYSTEM_TIME_H

class ACE_Date_Time
  // TITLE
  //.   This class holds internally date and time and has interfaces
  //    for getting month or compares of times and dates, etc.
{
public:
};

class ACE_System_Time
  // = TITLE
  //     Defines the timer services of the OS interface to access the
  //     system time either on the local host or on the central time
  //     server in the network.
{
public:
  enum Sync_Mode { Jump, Adjust };
  // enumeration types to specify mode of synchronization with master
  // clock.  Just will set local system time directly (thus possibly
  // producing time gaps or ambiguous local system times.  Adjust will
  // smoothly slow down or speed up the local system clock to reach
  // the system time of the master clock.

  int get_local_system_time (ACE_Date_Time &localsystime_out);
  // get the local system time

  int get_master_system_time (ACE_Date_Time &mastersystime_out);
  // get the system time of the central time server

  int sync_local_system_time (ACE_System_Time::Sync_Mode mode);
  // synchronize local system time with the central time server using
  // specified mode.
};

#include "ace/System_Time.i"
#endif /* ACE_SYSTEM_TIME_H */
