dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_PROG_CC_POSIX,[
	AC_PROG_CC
	AC_PROG_CPP
	AC_ISC_POSIX
	AC_MINIX]
)

AC_DEFUN(OST_PROG_COMMON,[
	AC_REQUIRE([AC_PROG_INSTALL])
	AC_REQUIRE([AC_PROG_MAKE_SET])
])

AC_DEFUN(OST_PROJ_LIBRARY,[
	AC_REQUIRE([AM_PROG_LIBTOOL])
	AC_REQUIRE([AC_PROG_RANLIB])
	if test ! -z "[$2]" ; then
		if test ! -z "[$3]" ; then
			LT_[$1]_VERSION="-version-info [$3] -release [$2]"
		else	
			LT_[$1]_VERSION="-release [$2]"
		fi
		AC_SUBST(LT_[$1]_VERSION)
	fi
])

AC_DEFUN(OST_PROG_LIBRARY,[
	AC_REQUIRE([AM_PROG_LIBTOOL])
	AC_REQUIRE([AC_PROG_RANLIB])
	if test ! -z "[$2]" ; then
		LT_[$1]_VERSION="-version-info [$2]"
		AC_SUBST(LT_[$1]_VERSION)
	fi
])



# serial 40 AC_PROG_LIBTOOL
AC_DEFUN(AC_PROG_LIBTOOL,
[AC_REQUIRE([AC_LIBTOOL_SETUP])dnl

# Save cache, so that ltconfig can load it
AC_CACHE_SAVE

# Actually configure libtool.  ac_aux_dir is where install-sh is found.
CC="$CC" CFLAGS="$CFLAGS" CPPFLAGS="$CPPFLAGS" \
LD="$LD" LDFLAGS="$LDFLAGS" LIBS="$LIBS" \
LN_S="$LN_S" NM="$NM" RANLIB="$RANLIB" \
DLLTOOL="$DLLTOOL" AS="$AS" OBJDUMP="$OBJDUMP" \
${CONFIG_SHELL-/bin/sh} $ac_aux_dir/ltconfig --no-reexec \
$libtool_flags --no-verify $ac_aux_dir/ltmain.sh $host \
|| AC_MSG_ERROR([libtool configure failed])

# Reload cache, that may have been modified by ltconfig
AC_CACHE_LOAD

# This can be used to rebuild libtool when needed
LIBTOOL_DEPS="$ac_aux_dir/ltconfig $ac_aux_dir/ltmain.sh"

# Always use our own libtool.
LIBTOOL='$(SHELL) $(top_builddir)/libtool'
AC_SUBST(LIBTOOL)dnl

# Redirect the config.log output again, so that the ltconfig log is not
# clobbered by the next message.
exec 5>>./config.log
])

AC_DEFUN(AC_LIBTOOL_SETUP,
[AC_PREREQ(2.13)dnl
AC_REQUIRE([AC_ENABLE_SHARED])dnl
AC_REQUIRE([AC_ENABLE_STATIC])dnl
AC_REQUIRE([AC_ENABLE_FAST_INSTALL])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
AC_REQUIRE([AC_PROG_RANLIB])dnl
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_LD])dnl
AC_REQUIRE([AC_PROG_NM])dnl
AC_REQUIRE([AC_PROG_LN_S])dnl
dnl

# Check for any special flags to pass to ltconfig.
#
# the following will cause an existing older ltconfig to fail, so
# we ignore this at the expense of the cache file... Checking this 
# will just take longer ... bummer!
#libtool_flags="--cache-file=$cache_file"
#
test "$enable_shared" = no && libtool_flags="$libtool_flags --disable-shared"
test "$enable_static" = no && libtool_flags="$libtool_flags --disable-static"
test "$enable_fast_install" = no && libtool_flags="$libtool_flags --disable-fast-install"
test "$ac_cv_prog_gcc" = yes && libtool_flags="$libtool_flags --with-gcc"
test "$ac_cv_prog_gnu_ld" = yes && libtool_flags="$libtool_flags --with-gnu-ld"
ifdef([AC_PROVIDE_AC_LIBTOOL_DLOPEN],
[libtool_flags="$libtool_flags --enable-dlopen"])
ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[libtool_flags="$libtool_flags --enable-win32-dll"])
AC_ARG_ENABLE(libtool-lock,
  [  --disable-libtool-lock  avoid locking (might break parallel builds)])
test "x$enable_libtool_lock" = xno && libtool_flags="$libtool_flags --disable-lock"
test x"$silent" = xyes && libtool_flags="$libtool_flags --silent"

# Some flags need to be propagated to the compiler or linker for good
# libtool support.
case "$host" in
*-*-irix6*)
  # Find out which ABI we are using.
  echo '[#]line __oline__ "configure"' > conftest.$ac_ext
  if AC_TRY_EVAL(ac_compile); then
    case "`/usr/bin/file conftest.o`" in
    *32-bit*)
      LD="${LD-ld} -32"
      ;;
    *N32*)
      LD="${LD-ld} -n32"
      ;;
    *64-bit*)
      LD="${LD-ld} -64"
      ;;
    esac
  fi
  rm -rf conftest*
  ;;

*-*-sco3.2v5*)
  # On SCO OpenServer 5, we need -belf to get full-featured binaries.
  SAVE_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS -belf"
  AC_CACHE_CHECK([whether the C compiler needs -belf], lt_cv_cc_needs_belf,
    [AC_TRY_LINK([],[],[lt_cv_cc_needs_belf=yes],[lt_cv_cc_needs_belf=no])])
  if test x"$lt_cv_cc_needs_belf" != x"yes"; then
    # this is probably gcc 2.8.0, egcs 1.0 or newer; no need for -belf
    CFLAGS="$SAVE_CFLAGS"
  fi
  ;;

ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[*-*-cygwin* | *-*-mingw*)
  AC_CHECK_TOOL(DLLTOOL, dlltool, false)
  AC_CHECK_TOOL(AS, as, false)
  AC_CHECK_TOOL(OBJDUMP, objdump, false)
  ;;
])
esac
])

# AC_LIBTOOL_DLOPEN - enable checks for dlopen support
AC_DEFUN(AC_LIBTOOL_DLOPEN, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])])

# AC_LIBTOOL_WIN32_DLL - declare package support for building win32 dll's
AC_DEFUN(AC_LIBTOOL_WIN32_DLL, [AC_BEFORE([$0], [AC_LIBTOOL_SETUP])])

# AC_ENABLE_SHARED - implement the --enable-shared flag
# Usage: AC_ENABLE_SHARED[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_SHARED, [dnl
define([AC_ENABLE_SHARED_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(shared,
changequote(<<, >>)dnl
<<  --enable-shared[=PKGS]  build shared libraries [default=>>AC_ENABLE_SHARED_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_shared=yes ;;
no) enable_shared=no ;;
*)
  enable_shared=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_shared=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_shared=AC_ENABLE_SHARED_DEFAULT)dnl
])

# AC_DISABLE_SHARED - set the default shared flag to --disable-shared
AC_DEFUN(AC_DISABLE_SHARED, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_SHARED(no)])

# AC_ENABLE_STATIC - implement the --enable-static flag
# Usage: AC_ENABLE_STATIC[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_STATIC, [dnl
define([AC_ENABLE_STATIC_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(static,
changequote(<<, >>)dnl
<<  --enable-static[=PKGS]  build static libraries [default=>>AC_ENABLE_STATIC_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_static=yes ;;
no) enable_static=no ;;
*)
  enable_static=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_static=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_static=AC_ENABLE_STATIC_DEFAULT)dnl
])

# AC_DISABLE_STATIC - set the default static flag to --disable-static
AC_DEFUN(AC_DISABLE_STATIC, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_STATIC(no)])


# AC_ENABLE_FAST_INSTALL - implement the --enable-fast-install flag
# Usage: AC_ENABLE_FAST_INSTALL[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_FAST_INSTALL, [dnl
define([AC_ENABLE_FAST_INSTALL_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(fast-install,
changequote(<<, >>)dnl
<<  --enable-fast-install[=PKGS]  optimize for fast installation [default=>>AC_ENABLE_FAST_INSTALL_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_fast_install=yes ;;
no) enable_fast_install=no ;;
*)
  enable_fast_install=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_fast_install=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_fast_install=AC_ENABLE_FAST_INSTALL_DEFAULT)dnl
])

# AC_ENABLE_FAST_INSTALL - set the default to --disable-fast-install
AC_DEFUN(AC_DISABLE_FAST_INSTALL, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_FAST_INSTALL(no)])

# AC_PROG_LD - find the path to the GNU or non-GNU linker
AC_DEFUN(AC_PROG_LD,
[AC_ARG_WITH(gnu-ld,
[  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]],
test "$withval" = no || with_gnu_ld=yes, with_gnu_ld=no)
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
ac_prog=ld
if test "$ac_cv_prog_gcc" = yes; then
  # Check if gcc -print-prog-name=ld gives a path.
  AC_MSG_CHECKING([for ld used by GCC])
  ac_prog=`($CC -print-prog-name=ld) 2>&5`
  case "$ac_prog" in
    # Accept absolute paths.
changequote(,)dnl
    [\\/]* | [A-Za-z]:[\\/]*)
      re_direlt='/[^/][^/]*/\.\./'
changequote([,])dnl
      # Canonicalize the path of ld
      ac_prog=`echo $ac_prog| sed 's%\\\\%/%g'`
      while echo $ac_prog | grep "$re_direlt" > /dev/null 2>&1; do
	ac_prog=`echo $ac_prog| sed "s%$re_direlt%/%"`
      done
      test -z "$LD" && LD="$ac_prog"
      ;;
  "")
    # If it fails, then pretend we aren't using GCC.
    ac_prog=ld
    ;;
  *)
    # If it is relative, then search for the first ld in PATH.
    with_gnu_ld=unknown
    ;;
  esac
elif test "$with_gnu_ld" = yes; then
  AC_MSG_CHECKING([for GNU ld])
else
  AC_MSG_CHECKING([for non-GNU ld])
fi
AC_CACHE_VAL(ac_cv_path_LD,
[if test -z "$LD"; then
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f "$ac_dir/$ac_prog" || test -f "$ac_dir/$ac_prog$ac_exeext"; then
      ac_cv_path_LD="$ac_dir/$ac_prog"
      # Check to see if the program is GNU ld.  I'd rather use --version,
      # but apparently some GNU ld's only accept -v.
      # Break only if it was the GNU/non-GNU ld that we prefer.
      if "$ac_cv_path_LD" -v 2>&1 < /dev/null | egrep '(GNU|with BFD)' > /dev/null; then
	test "$with_gnu_ld" != no && break
      else
	test "$with_gnu_ld" != yes && break
      fi
    fi
  done
  IFS="$ac_save_ifs"
else
  ac_cv_path_LD="$LD" # Let the user override the test with a path.
fi])
LD="$ac_cv_path_LD"
if test -n "$LD"; then
  AC_MSG_RESULT($LD)
else
  AC_MSG_RESULT(no)
fi
test -z "$LD" && AC_MSG_ERROR([no acceptable ld found in \$PATH])
AC_SUBST(LD)
AC_PROG_LD_GNU
])

AC_DEFUN(AC_PROG_LD_GNU,
[AC_CACHE_CHECK([if the linker ($LD) is GNU ld], ac_cv_prog_gnu_ld,
[# I'd rather use --version here, but apparently some GNU ld's only accept -v.
if $LD -v 2>&1 </dev/null | egrep '(GNU|with BFD)' 1>&5; then
  ac_cv_prog_gnu_ld=yes
else
  ac_cv_prog_gnu_ld=no
fi])
])

# AC_PROG_NM - find the path to a BSD-compatible name lister
AC_DEFUN(AC_PROG_NM,
[AC_MSG_CHECKING([for BSD-compatible nm])
AC_CACHE_VAL(ac_cv_path_NM,
[if test -n "$NM"; then
  # Let the user override the test.
  ac_cv_path_NM="$NM"
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH /usr/ccs/bin /usr/ucb /bin; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/nm || test -f $ac_dir/nm$ac_exeext ; then
      # Check to see if the nm accepts a BSD-compat flag.
      # Adding the `sed 1q' prevents false positives on HP-UX, which says:
      #   nm: unknown option "B" ignored
      if ($ac_dir/nm -B /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -B"
	break
      elif ($ac_dir/nm -p /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -p"
	break
      else
	ac_cv_path_NM=${ac_cv_path_NM="$ac_dir/nm"} # keep the first match, but
	continue # so that we can try to find one that supports BSD flags
      fi
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_NM" && ac_cv_path_NM=nm
fi])
NM="$ac_cv_path_NM"
AC_MSG_RESULT([$NM])
AC_SUBST(NM)
])

# AC_CHECK_LIBM - check for math library
AC_DEFUN(AC_CHECK_LIBM,
[AC_REQUIRE([AC_CANONICAL_HOST])dnl
LIBM=
case "$host" in
*-*-beos* | *-*-cygwin*)
  # These system don't have libm
  ;;
*-ncr-sysv4.3*)
  AC_CHECK_LIB(mw, _mwvalidcheckl, LIBM="-lmw")
  AC_CHECK_LIB(m, main, LIBM="$LIBM -lm")
  ;;
*)
  AC_CHECK_LIB(m, main, LIBM="-lm")
  ;;
esac
])

# AC_LIBLTDL_CONVENIENCE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl convenience library, adds --enable-ltdl-convenience to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
AC_DEFUN(AC_LIBLTDL_CONVENIENCE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  case "$enable_ltdl_convenience" in
  no) AC_MSG_ERROR([this package needs a convenience libltdl]) ;;
  "") enable_ltdl_convenience=yes
      ac_configure_args="$ac_configure_args --enable-ltdl-convenience" ;;
  esac
  LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdlc.la
  INCLTDL=ifelse($#,1,-I$1,['-I${top_builddir}/libltdl'])
])

# AC_LIBLTDL_INSTALLABLE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl installable library, and adds --enable-ltdl-install to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
# In the future, this macro may have to be called after AC_PROG_LIBTOOL.
AC_DEFUN(AC_LIBLTDL_INSTALLABLE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  AC_CHECK_LIB(ltdl, main,
  [test x"$enable_ltdl_install" != xyes && enable_ltdl_install=no],
  [if test x"$enable_ltdl_install" = xno; then
     AC_MSG_WARN([libltdl not installed, but installation disabled])
   else
     enable_ltdl_install=yes
   fi
  ])
  if test x"$enable_ltdl_install" = x"yes"; then
    ac_configure_args="$ac_configure_args --enable-ltdl-install"
    LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdl.la
    INCLTDL=ifelse($#,1,-I$1,['-I${top_builddir}/libltdl'])
  else
    ac_configure_args="$ac_configure_args --enable-ltdl-install=no"
    LIBLTDL="-lltdl"
    INCLTDL=
  fi
])

dnl old names
AC_DEFUN(AM_PROG_LIBTOOL, [indir([AC_PROG_LIBTOOL])])dnl
AC_DEFUN(AM_ENABLE_SHARED, [indir([AC_ENABLE_SHARED], $@)])dnl
AC_DEFUN(AM_ENABLE_STATIC, [indir([AC_ENABLE_STATIC], $@)])dnl
AC_DEFUN(AM_DISABLE_SHARED, [indir([AC_DISABLE_SHARED], $@)])dnl
AC_DEFUN(AM_DISABLE_STATIC, [indir([AC_DISABLE_STATIC], $@)])dnl
AC_DEFUN(AM_PROG_LD, [indir([AC_PROG_LD])])dnl
AC_DEFUN(AM_PROG_NM, [indir([AC_PROG_NM])])dnl

dnl This is just to silence aclocal about the macro not being used
ifelse([AC_DISABLE_FAST_INSTALL])dnl

dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_AUTOMAKE_MODE,[
	AC_MSG_CHECKING([for genorated automake files])
	if test -z "[$1]" ; then
		ost_AUTOMAKE_TEST=Makefile.in
	else
		ost_AUTOMAKE_TEST=[$1]
	fi
	if test ! -f $ost_AUTOMAKE_TEST ; then 
		AC_MSG_RESULT(missing)
		automake -a 
	else
		AC_MSG_RESULT(found)
	fi]
)

AC_DEFUN(OST_MAINTAINER_MODE,[
	AM_MAINTAINER_MODE
	if test -z "$MAINT" ; then
		AC_MSG_CHECKING([for maintainer ftp distribution directory])
		if test -d ~ftp/pub ; then
			FTPDIR=~ftp/pub
			AC_MSG_RESULT(found)
		else
			AC_MSG_RESULT(missing)
		fi
	fi
	AC_SUBST(FTPDIR)
	]
)


# Add --enable-maintainer-mode option to configure.
# From Jim Meyering

# serial 1

AC_DEFUN(AM_MAINTAINER_MODE,
[AC_MSG_CHECKING([whether to enable maintainer-specific portions of Makefiles])
  dnl maintainer-mode is disabled by default
  AC_ARG_ENABLE(maintainer-mode,
[  --enable-maintainer-mode enable make rules and dependencies not useful
                          (and sometimes confusing) to the casual installer],
      USE_MAINTAINER_MODE=$enableval,
      USE_MAINTAINER_MODE=no)
  AC_MSG_RESULT($USE_MAINTAINER_MODE)
  AM_CONDITIONAL(MAINTAINER_MODE, test $USE_MAINTAINER_MODE = yes)
  MAINT=$MAINTAINER_MODE_TRUE
  AC_SUBST(MAINT)dnl
]
)

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_WIN32,
[
AC_REQUIRE([OST_PROG_CC_POSIX])
AC_CACHE_CHECK(for Win32 gnu environment, ost_cv_gnuwin32,
[
	AC_TRY_COMPILE([
		#ifdef	__WIN32__
		#ifdef __MINGW32__
		#define	__RETURN_WIN32__ __MINGW32__
		#endif
		#ifdef __CYGWIN32__
		#define __RETURN_WIN32__ __CYGWIN32__
		#endif
		#endif
	],[return __RETURN_WIN32__;],
        [AC_DEFINE(__DLL, "__EXPORT")
	ost_cv_gnuwin32=yes],[
	AC_DEFINE(__DLL,)
        AC_DEFINE(__EXPORT,)
	ost_cv_gnuwin32=no])
	rm -f conftest*
])
])

dnl ACCONFIG TEMPLATE
dnl #undef __DLL
dnl #undef __EXPORT
dnl END ACCONFIG

dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_CXX_PROGRAMMING,[
 AC_REQUIRE([OST_PROG_CC_POSIX])
 AC_PROG_CPP
 AC_PROG_CXX
 AC_PROG_CXXCPP

  dnl
  dnl Check for common C++ portability problems
  dnl

  AC_LANG_SAVE
  AC_LANG_CPLUSPLUS

  dnl Check whether we have bool
  AC_CACHE_CHECK(whether ${CXX} has built-in bool type,
	ac_cv_cxx_bool_type,
	AC_TRY_COMPILE(,
	     [bool b1=true; bool b2=false;],
             ac_cv_cxx_bool_type=yes,
	     ac_cv_cxx_bool_type=no
        )
  )

  if test $ac_cv_cxx_bool_type = yes ; then
	AC_DEFINE(HAVE_BOOL_TYPE)
  fi

  AC_LANG_RESTORE
])

AC_DEFUN(OST_CXX_EXCEPTIONS,[
  AC_REQUIRE([OST_CXX_PROGRAMMING])

  dnl 
  dnl Enable C++ exception handling whenever possible.
  dnl 

  AC_LANG_SAVE
  AC_LANG_CPLUSPLUS

  dnl strip -fno-exceptions flag if used
  optflags=$CXXFLAGS
  if test ! -z "$optflags" ; then
	CXXFLAGS=""
	for opt in $optflags ; do
 		case $opt in
		*no-exceptions*)
			;;
		*)
			CXXFLAGS="$CXXFLAGS $opt"
			;;
		esac
	done
  fi

  dnl Check for exception handling
  AC_CACHE_CHECK(whether ${CXX} supports -fhandle-exceptions,
	ac_cv_cxx_exception_flag,
	[echo 'void f(){}' >conftest.c
	 if test -z "`${CXX} -fhandle-exceptions -c conftest.c 2>&1`"; then
		ac_cv_cxx_exception_flag=yes
		CXXFLAGS="$CXXFLAGS -fhandle-exceptions"
	 else
		ac_cv_cxx_exception_flag=no
	 fi
	 rm -f conftest*
	 ])

  if test $ac_cv_cxx_exception_flag = "yes" ; then
    ac_cv_cxx_exception_handling=yes
  else
    AC_CACHE_CHECK(whether ${CXX} supports exception handling,
	ac_cv_cxx_exception_handling,
	AC_TRY_COMPILE(
	    [void f(void) 
	     { 
		throw "abc";
	     } 
	     void g(void) 
	     { 
		try 
		{ 
		   f(); 
		} 
		catch(char*){} 
	    }
	    ],,
	    ac_cv_cxx_exception_handling=yes,
	    ac_cv_cxx_exception_handling=no
	)
    )
  fi

  if test $ac_cv_cxx_exception_handling = yes ; then
	AC_DEFINE(HAVE_EXCEPTION_HANDLING)
  fi

  AC_LANG_RESTORE
])

dnl ACCONFIG TEMPLATE
dnl #undef HAVE_BOOL_TYPE
dnl #undef HAVE_EXCEPTION_HANDLING
dnl END ACCONFIG

dnl ACCONFIG BOTTOM
dnl  
dnl // Add bool support if missing
dnl #ifndef HAVE_BOOL_TYPE
dnl typedef enum { true=1, false=0 } bool;
dnl #endif
dnl 
dnl // replace 'throw' with abort for libs on broken C++
dnl #ifndef HAVE_EXCEPTION_HANDLING
dnl #define throw(x) abort()
dnl #define try if(1)
dnl #define catch(x) if(0)
dnl #endif
dnl 
dnl END ACCONFIG


dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_CC_TYPES,[
	AC_REQUIRE([OST_SYS_POSIX])
	AC_CHECK_HEADERS(sys/types.h)
	AC_EGREP_HEADER(u_int8_t,sys/types.h,[
		AC_DEFINE(HAVE_SYS_TYPES_STD)
		AC_EGREP_HEADER(u_int64_t,sys/types.h,[
			AC_DEFINE(HAVE_SYS_TYPES_64)
			AC_DEFINE(HAVE_64_BITS)
			])	
		])
	AC_EGREP_HEADER(long long,sys/types.h,[
		AC_DEFINE(HAVE_LONG_LONG)
		AC_DEFINE(HAVE_64_BITS)])
])

dnl ACCONFIG TEMPLATE
dnl #undef HAVE_SYS_TYPES_STD
dnl #undef HAVE_SYS_TYPES_64
dnl #undef HAVE_LONG_LONG
dnl #undef HAVE_64_BITS
dnl #undef HAVE_SYS_TYPES_H
dnl END ACCONFIG

dnl ACCONFIG BOTTOM
dnl  
dnl #ifdef HAVE_SYS_TYPES_H
dnl #include <sys/types.h>
dnl #endif
dnl #ifdef HAVE_SYS_TYPES_STD
dnl typedef int8_t _int8;
dnl typedef u_int8_t _uint8;
dnl typedef int16_t _int16;
dnl typedef u_int16_t _uint16;
dnl typedef int32_t _int32;
dnl typedef u_int32_t _uint32;
dnl #ifdef HAVE_SYS_TYPES_64
dnl typedef int64_t _int64;
dnl typedef u_int64_t _uint64;
dnl #endif
dnl #else
dnl typedef char _int8;
dnl typedef unsigned char _uint8;
dnl typedef short _int16;
dnl typedef unsigned short _int16;
dnl typedef int _int32;
dnl typedef unsigned int _uint32;
dnl #endif
dnl #ifndef HAVE_SYS_TYPES64
dnl #ifdef HAVE_LONG_LONG
dnl typedef long long _int64;
dnl typedef unsigned long long _uint64;
dnl #endif
dnl #endif
dnl 
dnl END ACCONFIG


dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_SYS_POSIX,[
 AC_REQUIRE([OST_PROG_CC_POSIX])
 AC_CACHE_CHECK(whether system meets Posix.1,
	ost_cv_sys_posix1,
	AC_TRY_COMPILE(,[
		#include <sys/types.h>
		#include <unistd.h>
		#ifndef	_POSIX_VERSION
		fatal
		#endif
		],		
             ost_cv_sys_posix1=yes,
	     ost_cv_sys_posix1=no
        )
  )
  if test $ost_cv_sys_posix1 = no ; then
	AC_CHECK_HEADERS(unistd.h)
  else
	AC_DEFINE(HAVE_UNISTD_H)
  fi
])

dnl ACCONFIG BOTTOM
dnl  
dnl #ifdef HAVE_UNISTD_H
dnl #include <unistd.h>
dnl #endif
dnl 
dnl END ACCONFIG


dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_CC_SIGNAL,[
	AC_REQUIRE([OST_SYS_POSIX])
	AC_CHECK_FUNCS(sigaction)
	AC_CHECK_HEADERS(bsd/signal.h)
	AC_TYPE_SIGNAL
])

dnl ACCONFIG TEMPLATE
dnl #undef HAVE_SIGACTION
dnl #undef HAVE_BSD_SIGNAL_H
dnl END ACCONFIG

dnl ACCONFIG BOTTOM
dnl  
dnl #ifdef HAVE_SIGACTION
dnl #ifdef HAVE_BSD_SIGNAL_H
dnl #undef HAVE_BSD_SIGNAL_H
dnl #endif
dnl #endif
dnl 
dnl #ifdef HAVE_BSD_SIGNAL_H
dnl #include <bsd/signal.h>
dnl #else
dnl #include <signal.h>
dnl #endif
dnl 
dnl #ifndef SA_ONESHOT
dnl #define SA_ONESHOT SA_RESETHAND
dnl #endif
dnl 
dnl END ACCONFIG


dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_CC_STRING,[
	AC_REQUIRE([OST_SYS_POSIX])
	AC_CHECK_FUNCS(strcasecmp strdup)
])

dnl ACCONFIG TEMPLATE
dnl #undef HAVE_STRCASECMP
dnl #undef HAVE_STRDUP
dnl END ACCONFIG

dnl ACCONFIG BOTTOM
dnl  
dnl #include <string.h>
dnl 
dnl #ifdef HAVE_STRCASECMP
dnl #ifndef stricmp
dnl #define stricmp(x,y) strcasecmp(x,y)
dnl #endif
dnl #ifndef strnicmp
dnl #define strnicmp(x,y,n) strncasecmp(x,y,n)
dnl #endif
dnl #endif
dnl 
dnl #ifndef HAVE_STRDUP
dnl #define strdup(s) (char *)malloc(strlen(s))
dnl #endif
dnl 
dnl END ACCONFIG


dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_CC_DYNAMIC,[
	DYN_LOADER=''
	ost_ct_dynloader=no
	AC_REQUIRE([OST_SYS_POSIX])
	AC_CHECK_HEADERS(dlfcn.h)
	AC_CHECK_LIB(dl, dlopen, [DYN_LOADER=-ldl])
	if test ! -z "$DYN_LOADER" ; then
		ost_cv_dynloader=yes
		AC_DEFINE(HAVE_MODULES)
	fi
	AC_SUBST(DYN_LOADER)	
])

dnl ACCONFIG TEMPLATE
dnl #undef HAVE_DLOPEN
dnl #undef HAVE_MODULES
dnl #undef HAVE_DLFCN_H
dnl END ACCONFIG

dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_LIB_PTHREAD,
[
  AC_REQUIRE([OST_SYS_POSIX])
  AC_REQUIRE([OST_HEADER_SYSTIME])
  THREAD_FLAGS="-D_REENTRANT -D_THREAD_SAFE"
  THREAD_LIBS=
  AC_CHECK_HEADERS(pthread.h,
	ost_cv_posix_threads=yes,
	ost_cv_posix_threads=no)

  if test $ost_cv_posix_threads = yes ; then
	AC_CACHE_CHECK(whether ${CC-cc} accepts -pthread,
		ost_cv_prog_cc_pthread,
		[echo 'void f(){}' >conftest.c
		if test -z "`${CC-cc} -pthread -c conftest.c 2>&1`"; then
			ost_cv_prog_cc_pthread=yes
		else
			ost_cv_prog_cc_pthread=no
		fi
		rm -f conftest*
		])
	ost_cv_thread_library=none
	AC_CHECK_LIB(pthread, pthread_self,
		ost_cv_thread_library=pthread,
		AC_CHECK_LIB(pthread, pthread_kill,
			ost_cv_thread_library=pthread,
			AC_CHECK_LIB(pthreads, pthread_self,
				ost_cv_thread_library=pthreads)))

	if test $ost_cv_thread_library = none ; then
		AC_CHECK_LIB(gthreads, pthread_self,[
			AC_CHECK_LIB(malloc, malloc)
			ost_cv_thread_library=gthreads])
	fi	
	if test $ost_cv_thread_library = none ; then	
		AC_CHECK_LIB(cma, pthread_self,
			ost_cv_thread_library=cma)
	fi

	if test $ost_cv_thread_library = none ; then
		AC_CHECK_LIB(c_r, pthread_self,
			ost_cv_thread_library=c_r)
	fi

	if test $ost_cv_thread_library = none ; then
		AC_CHECK_LIB(c, pthread_self,
			ost_cv_thread_library=c)
	fi

	if test $ost_cv_thread_library = none ; then
		AC_MSG_ERROR(no library for posix threads found!)
	fi

	AC_CHECK_LIB($ost_cv_thread_library, nanosleep,
		AC_DEFINE(HAVE_PTHREAD_NANOSLEEP),[
		AC_CHECK_LIB(posix4, nanosleep,[
			AC_DEFINE(HAVE_PTHREAD_NANOSLEEP)
			THREAD_LIBS="$THREAD_LIBS -lposix4"
			],[
			AC_CHECK_LIB(rt, nanosleep,[
				AC_DEFINE(HAVE_PTHREAD_NANOSLEEP)
				THREAD_LIBS="$THREAD_LIBS -lrt"])
			])

		])

	if test $ost_cv_thread_library = c_r ; then
		if test $ost_cv_prog_cc_pthread = yes ; then
			ost_cv_thread_library=c
		fi
	fi

	if test $ost_cv_thread_library != c ; then
		THREAD_LIBS="$THREAD_LIBS -l$ost_cv_thread_library"
	fi

	if test $ost_cv_prog_cc_pthread = yes ; then
		THREAD_FLAGS="$THREAD_FLAGS -pthread"
	fi

	AC_SUBST(THREAD_FLAGS)
	AC_SUBST(THREAD_LIBS)
	AC_CHECK_HEADERS(pthread_np.h)
	AC_CHECK_HEADERS(semaphore.h)
	AC_CHECK_HEADERS(sched.h)
	AC_CHECK_HEADERS(sys/sched.h)
	AC_CACHE_CHECK("for recursive mutex type support", ost_cv_mutex_recursive,
	[
	ost_cv_mutex_recursive="none"
	AC_TRY_COMPILE(
		[#include <pthread.h>],
		[
		#ifndef PTHREAD_MUTEXTYPE_RECURSIVE
		#ifdef PTHREAD_MUTEX_RECURSIVE
		#define PTHREAD_MUTEXTYPE_RECURSIVE PTHREAD_MUTEX_RECURSIVE
		#endif
		#endif
		return (int)PTHREAD_MUTEXTYPE_RECURSIVE;
		],
		ost_cv_mutex_recursive="portable",
		[	
		AC_EGREP_HEADER(PTHREAD_MUTEXTYPE_RECURSIVE_NP,pthread.h,
			ost_cv_mutex_recursive=non-portable)
		AC_EGREP_HEADER(PTHREAD_MUTEX_RECURSIVE_NP,pthread.h,
			ost_cv_mutex_recursive=linux) 
		AC_EGREP_HEADER(MUTEX_TYPE_COUNTING_FAST,pthread.h,
			ost_cv_mutex_recursive=counting)	
		])
	rm -f conftest*
	])

	if test $ost_cv_mutex_recursive = "none" ; then
		AC_TRY_COMPILE(
			[#include <pthread.h>],
		 	[return MUTEX_TYPE_COUNTING_FAST;],
			ost_cv_mutex_recursive=counting)
	fi

	case $ost_cv_mutex_recursive in
	non-portable)
		AC_DEFINE(PTHREAD_MUTEXTYPE_RECURSIVE,
			PTHREAD_MUTEXTYPE_RECURSIVE_NP)
		;;
	linux)
		AC_DEFINE(PTHREAD_MUTEXTYPE_RECURSIVE,
			PTHREAD_MUTEX_RECURSIVE_NP)
		;;
	counting)
		AC_DEFINE(PTHREAD_MUTEXTYPE_RECURSIVE,
			MUTEX_TYPE_COUNTING_FAST)
		;;
	esac

	AC_CHECK_LIB($ost_cv_thread_library, pthread_mutexattr_settype,
		AC_DEFINE(HAVE_PTHREAD_MUTEXATTR_SETTYPE),
		[
		AC_CHECK_LIB($ost_cv_thread_library, pthread_mutexattr_settype_np,
			AC_DEFINE(HAVE_PTHREAD_MUTEXATTR_SETTYPE_NP))
		AC_CHECK_LIB($ost_cv_thread_library, pthread_mutexattr_setkind_np,
			AC_DEFINE(HAVE_PTHREAD_MUTEXATTR_SETKIND_NP))
		]
	)

	AC_CHECK_LIB($ost_cv_thread_library, pthread_attr_setstacksize,
		AC_DEFINE(HAVE_PTHREAD_ATTR_SETSTACKSIZE))

	AC_CHECK_LIB($ost_cv_thread_library, pthread_yield,
		AC_DEFINE(HAVE_PTHREAD_YIELD),[
		AC_CHECK_LIB($ost_cv_thread_library, sched_yield,
			AC_DEFINE(HAVE_PTHREAD_SCHED_YIELD))
		])

	AC_CHECK_LIB($ost_cv_thread_library, pthread_cancel,[
		AC_DEFINE(HAVE_PTHREAD_CANCEL)
	  	AC_CHECK_LIB($ost_cv_thread_library,
			pthread_setcanceltype,
			AC_DEFINE(HAVE_PTHREAD_SETCANCELTYPE),
			AC_CHECK_LIB($ost_cv_thread_library, pthread_setcanel,
				AC_DEFINE(HAVE_PTHREAD_SETCANCEL)))
		],[
		AC_CHECK_LIB($ost_cv_thread_library,
			pthread_setcanceltype,[
			AC_DEFINE(HAVE_PTHREAD_CANCEL)
			AC_DEFINE(HAVE_PTHREAD_SETCANCELTYPE)])

		])

	AC_CHECK_LIB($ost_cv_thread_library, pthread_delay_np,
		AC_DEFINE(HAVE_PTHREAD_DELAY_NP))
  fi
])

dnl ACCONFIG TEMPLATE
dnl #undef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #undef HAVE_PTHREAD_MUTEXATTR_SETTYPE
dnl #undef HAVE_PTHREAD_MUTEXATTR_SETTYPE_NP
dnl #undef HAVE_PTHREAD_MUTEXATTR_SETKIND_NP
dnl #undef HAVE_PTHREAD_ATTR_SETSTACKSIZE
dnl #undef HAVE_PTHREAD_DELAY_NP
dnl #undef HAVE_PTHREAD_SCHED_YIELD
dnl #undef HAVE_PTHREAD_YIELD
dnl #undef HAVE_PTHREAD_NANOSLEEP
dnl #undef HAVE_PTHREAD_CANCEL
dnl #undef HAVE_PTHREAD_SETCANCELTYPE
dnl #undef HAVE_PTHREAD_SETCANCEL
dnl END ACCONFIG

dnl ACCONFIG BOTTOM
dnl 
dnl #if defined(__SVR4) && defined(__sun)
dnl #define _THR_SUNOS5
dnl #else
dnl #if defined(__SVR4__) && defined(__SUN__)
dnl #define _THR_SUNOS5
dnl #endif
dnl #endif
dnl #ifdef _THR_SUNOS5
dnl #include "/usr/include/thread.h"
dnl #endif
dnl 
dnl #if defined(HAVE_PTHREAD_H) && defined(_THREAD_SAFE)
dnl #ifndef __USE_UNIX98
dnl #define __USE_UNIX98
dnl #include <pthread.h>
dnl #undef __USE_UNIX98
dnl #else
dnl #include <pthread.h>
dnl #endif
dnl #ifdef HAVE_PTHREAD_NP_H
dnl #include <pthread_np.h>
dnl #endif
dnl #ifdef HAVE_SEMAPHORE_H
dnl #include <semaphore.h>
dnl #endif
dnl #ifdef _POSIX_PRIORITY_SCHEDULING
dnl #ifdef HAVE_SCHED_H
dnl #include <sched.h>
dnl #else
dnl #ifdef HAVE_SYS_SCHED_H
dnl #include <sys/sched.h>
dnl #endif
dnl #endif
dnl #endif
dnl 
dnl #define __PTHREAD_H__
dnl #ifndef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #ifdef  MUTEX_TYPE_COUNTING_FAST
dnl #define PTHREAD_MUTEXTYPE_RECURSIVE MUTEX_TYPE_COUNTING_FAST
dnl #endif
dnl #endif
dnl #ifndef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #ifdef  PTHREAD_MUTEX_RECURSIVE
dnl #define PTHREAD_MUTEXTYPE_RECURSIVE PTHREAD_MUTEX_RECURSIVE
dnl #endif
dnl #endif
dnl #ifndef HAVE_PTHREAD_MUTEXATTR_SETTYPE
dnl #if     HAVE_PTHREAD_MUTEXATTR_SETKIND_NP
dnl #ifndef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #define PTHREAD_MUTEXTYPE_RECURSIVE PTHREAD_MUTEX_RECURSIVE_NP
dnl #endif
dnl #define pthread_mutexattr_gettype(x, y) pthread_mutexattr_getkind_np(x, y)
dnl #define pthread_mutexattr_settype(x, y) pthread_mutexattr_setkind_np(x, y)
dnl #endif 
dnl #if     HAVE_PTHREAD_MUTEXATTR_SETTYPE_NP
dnl #ifndef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #define PTHREAD_MUTEXTYPE_RECURSIVE PTHREAD_MUTEXTYPE_RECURSIVE_NP
dnl #endif
dnl #define pthread_mutexattr_settype(x, y) pthread_mutexattr_settype_np(x, y)
dnl #define pthread_mutexattr_gettype(x, y) pthread_mutexattr_gettype_np(x, y)
dnl #endif
dnl #endif
dnl 
dnl #ifndef HAVE_PTHREAD_YIELD
dnl #ifdef HAVE_PTHREAD_SCHED_YIELD
dnl #define pthread_yield() sched_yield()
dnl #define HAVE_PTHREAD_YIELD
dnl #endif
dnl #endif
dnl 
dnl #ifndef HAVE_PTHREAD_DELAY
dnl #ifdef HAVE_PTHREAD_DELAY_NP
dnl #define HAVE_PTHREAD_DELAY
dnl #define pthread_delay(x) pthread_delay_np(x)
dnl #endif
dnl #ifdef HAVE_PTHREAD_NANOSLEEP
dnl #ifndef HAVE_PTHREAD_DELAY
dnl #define HAVE_PTHREAD_DELAY
dnl #define pthread_delay(x) nanosleep(x, NULL)
dnl #endif
dnl #endif
dnl #endif
dnl 
dnl #ifdef HAVE_PTHREAD_ATTR_SETSTACK
dnl #ifndef PTHREAD_STACK_MIN
dnl #define PTHREAD_STACK_MIN 8192
dnl #endif
dnl #endif
dnl 
dnl #ifndef HAVE_PTHREAD_CANCEL
dnl #ifdef SIGCANCEL
dnl #define _SIG_THREAD_CANCEL SIGCANCEL
dnl #else
dnl #define _SIG_THREAD_CANCEL SIGQUIT
dnl #endif
dnl #define pthread_cancel(x) pthread_kill(x, _SIG_THREAD_CANCEL)
dnl #endif
dnl 
dnl #ifndef HAVE_PTHREAD_SETCANCELTYPE
dnl #ifdef HAVE_PTHREAD_SETCANCEL
dnl enum
dnl { PTHREAD_CANCEL_ASYNCHRONOUS = CANCEL_ON,
dnl   PTHREAD_CANCEL_DEFERRED = CANCEL_OFF};
dnl enum
dnl { PTHREAD_CANCEL_ENABLE = CANCEL_ON,
dnl   PTHREAD_CANCEL_DISABLE = CANCEL_OFF};
dnl #define pthread_setcancelstate(x, y) \
dnl 	(y == NULL) ? pthread_setcancel(x) : *y = pthread_setcancel
dnl #define pthread_setcanceltype(x, y) \
dnl 	(y == NULL) ? pthread_setasynccancel(x) | *y = pthread_setasynccancel(x)
dnl #else
dnl #define pthread_setcanceltype(x, y)
dnl #define pthread_setcancelstate(x, y)
dnl #endif
dnl #endif
dnl 
dnl #endif
dnl 
dnl END ACCONFIG


dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_HEADER_SYSTIME,[
	AC_HEADER_TIME
	AC_CHECK_HEADERS(sys/time.h)
])

dnl ACCONFIG TEMPLATE
dnl #undef HAVE_SYS_TIME_H
dnl #undef TIME_WITH_SYS_TIME
dnl END ACCONFIG

dnl ACCONFIG BOTTOM
dnl  
dnl #if TIME_WITH_SYS_TIME
dnl #include <sys/time.h>
dnl #include <time.h>
dnl #else
dnl #if HAVE_SYS_TIME_H
dnl #include <sys/time.h>
dnl #else
dnl #include <time.h>
dnl #endif
dnl #endif
dnl 
dnl END ACCONFIG


dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_LIB_SOCKET,[
	AC_REQUIRE([OST_HEADER_SYSTIME])
	ost_cv_inet_sockets=no
	ost_cv_unix_sockets=no
	ost_cv_lib_socket="c"
	AC_CHECK_HEADERS(sys/socket.h,[
		AC_CHECK_HEADERS(select.h sys/select.h netinet/in_systm.h netinet/ip.h)
		AC_CHECK_HEADERS(arpa/inet.h,
			ost_cv_inet_sockets=yes)
		AC_CHECK_HEADERS(sys/un.h,
			ost_cv_unix_sockets=yes)
		], AC_CHECK_HEADERS(winsock.h,
			ost_cv_inet_sockets=yes))
	AC_CHECK_LIB(socket, socket, [
		ost_cv_lib_socket="socket"
		LIBS="$LIBS -lsocket"
		])

	if test $ost_cv_inet_sockets = yes ; then
		AC_DEFINE(HAVE_INET_SOCKETS)
		AC_CHECK_LIB($ost_cv_lib_socket, inet_aton,[
			AC_DEFINE(HAVE_INET_ATON)])
		AC_CACHE_CHECK("for socklen_t defined", ost_cv_socklen_t, [ 
			ost_cv_socklen_t='no'
			AC_EGREP_HEADER(socklen_t, sys/socket.h,
				ost_cv_socklen_t='yes')
		])
		if test $ost_cv_socklen_t = yes ; then
			AC_DEFINE(HAVE_SOCKLEN_T)
		fi
	fi

	if test $ost_cv_unix_sockets = yes ; then
		AC_DEFINE(HAVE_UNIX_SOCKETS)
	fi
])

dnl ACCONFIG TEMPLATE
dnl #define _POSIX_PII_SOCKET
dnl #undef HAVE_SYS_SOCKET_H
dnl #undef HAVE_ARPA_INET_H
dnl #undef HAVE_NETINET_IN_SYSTM_H
dnl #undef HAVE_NETINET_IP_H
dnl #undef HAVE_SYS_UN_H
dnl #undef HAVE_SELECT_H
dnl #undef HAVE_SYS_SELECT_H
dnl #undef HAVE_INET_ATON
dnl #undef HAVE_INET_SOCKETS
dnl #undef HAVE_UNIX_SOCKETS
dnl #undef HAVE_SOCKLEN_T
dnl END ACCONFIG

dnl ACCONFIG BOTTOM
dnl  
dnl #ifdef HAVE_WINSOCK_H
dnl #include <winsock.h>
dnl #else
dnl #ifdef HAVE_SYS_SOCKET_H
dnl #include <sys/socket.h>
dnl #ifdef HAVE_SELECT_H
dnl #include <select.h>
dnl #else
dnl #ifdef HAVE_SYS_SELECT_H
dnl #include <sys/select.h>
dnl #endif
dnl #endif
dnl #ifdef HAVE_ARPA_INET_H
dnl #include <netinet/in.h>
dnl #include <arpa/inet.h>
dnl #include <netdb.h>
dnl #endif
dnl #ifdef HAVE_NETINET_IN_SYSTM_H
dnl #include <netinet/in_systm.h>
dnl #endif
dnl #ifdef HAVE_NETINET_IP_H
dnl #include <netinet/ip.h>
dnl #endif
dnl #ifdef HAVE_SYS_UN_H
dnl #include <sys/un.h>
dnl #endif
dnl #endif
dnl #endif
dnl 
dnl #ifndef HAVE_INET_ATON
dnl #define inet_aton(cp, addr) \
dnl 	(((*(unsigned long int *)(addr)) = inet_addr(cp)) != -1)
dnl #endif
dnl 
dnl #ifndef SUN_LEN
dnl #ifdef SCM_RIGHTS
dnl #define HAVE_UN_LEN
dnl #endif
dnl #ifdef __linux
dnl #define HAVE_UN_LEN
dnl #endif
dnl #ifdef HAVE_UN_LEN
dnl #define SUN_LEN(ptr) sizeof(sockaddr_un.sun_len) + \
dnl 	sizeof(sockaddr_un.sun_family) + sizeof(sockaddr_un.sun_path) + 1
dnl #else
dnl #define SUN_LEN(ptr) ((size_t)((struct sockaddr_un *)0)->sun_path) \
dnl 	+ strlen((ptr)->sun_path))
dnl #endif
dnl #endif
dnl 
dnl #ifndef HAVE_SOCKLEN_T
dnl typedef int socklen_t;
dnl #endif
dnl 
dnl END ACCONFIG


dnl Copyright (C) 1999-2000 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_APE_HEADER,[
	AC_DEFINE(__APE_CONFIG_H__)
])

AC_DEFUN(OST_LIB_APE,[
	ost_cv_ape_config=false
	if test -f ${includedir}/APE/config.def ; then
		ost_cv_ape_config=true
		THREAD_FLAGS=`grep flags ${includedir}/APE/config.def | sed s/flags://`
		THREAD_LIBS=`grep thread ${includedir}/APE/config.def | sed s/thread://`
		DYN_LOADER=`grep thread ${includedir}/APE/config.def | sed s/loader://`
		AC_SUBST(THREAD_FLAGS)
		AC_SUBST(THREAD_LIBS)
		AC_SUBST(DYN_LOADER)
	fi
])

dnl ACCONFIG TEMPLATE
dnl #undef __APE_CONFIG_H__
dnl END ACCONFIG

