
// Copyright (C) 1999 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "misc.h"
#include "audio.h"
#include "thread.h"
#include "rtp.h"
#include <sys/uio.h>

RTPBroadcast::RTPBroadcast(BroadcastAddress &ann, short port, int pri) :
RTPSocket(ann, port),
_start(0),
RTSSendThread(&_start, pri)
{
	rtpsend.flags[0] = 0x80;        // version 2 RTP, no conf ids
	rtpsend.flags[1] = 0x08;        // ULAW audio to start with
	setRTShort(rtpsend.sequence, 0);
	setRTLong(rtpsend.timestamp, 0);
	setRTLong(rtpsend.source, 0);
};

ssize_t RTPBroadcast::RTSSend(unsigned char *data, size_t len)
{
	unsigned char buffer[1500];
	AudioCodec *codec = getAudioEncoding(rtpsend.flags[1] & 0x7f);

	if(codec)
	{
		len = codec->Encode(buffer, data, len);
		data = buffer;
	}
	return Write(data, len);
}

RTPReceiver::RTPReceiver(InetAddress &bind, short port, int pri) :
RTPSocket(bind, port),
_start(0),
RTSRecvThread(&_start, pri)
{
};

ssize_t RTPReceiver::RTSRecv(unsigned char *data, unsigned short *encoding, unsigned long *timestamp)
{
	unsigned char buffer[1500];
	AudioCodec *codec = RTSRecvThread::getAudioEncoding(rtprecv.flags[1] & 0x7f);
	ssize_t rtn;
	
	*encoding = RTSRecvThread::getAudioSampling(rtprecv.flags[1] & 0x7f);
	*timestamp = getRTLong(rtprecv.timestamp);

	if(codec)
	{
		rtn = Read(buffer, sizeof(buffer));
		if(rtn < 1)
			return rtn;

		return codec->Decode(data, buffer, rtn);
	}
	rtn = Read(data, sizeof(buffer));
	if(rtn < 1)
		return rtn;
	return rtn;
}

RTPTransceiver::RTPTransceiver(InetAddress &bind, short port, int pri) :
RTPReceiver(bind, port, pri),
// RTPSocket(bind, port),
// _start(0),
// RTSRecvThread(&_start, pri),
RTSSendThread(&_start, pri)
{
	rtpsend.flags[0] = 0x80;        // version 2 RTP, no conf ids
	rtpsend.flags[1] = 0x08;        // ULAW audio to start with
	setRTShort(rtpsend.sequence, 0);
	setRTLong(rtpsend.timestamp, 0);
	setRTLong(rtpsend.source, 0);
};

void RTPTransceiver::Start(void)
{
	++_start;
	++_start;
}

void RTPTransceiver::setTimeout(timeout_t timer)
{
	RTSSendThread::setTimeout(timer);
	RTSRecvThread::setTimeout(timer);
}

ssize_t RTPTransceiver::RTSSend(unsigned char *data, size_t len)
{
	unsigned char buffer[1500];
	AudioCodec *codec = RTSSendThread::getAudioEncoding(rtpsend.flags[1] & 0x7f);

	if(codec)
	{
		len = codec->Encode(buffer, data, len);
		data = buffer;
	}
	return Write(data, len);
}


