/* net_errs.h
   Author: Marko Meyer
   Date: 05.06.1995 (last modification)
   Time-stamp: <96/01/07 15:45:20 mme>

   10.05.1995: list_errs.h derived from this.

   Errors presented during neural network.

   This file belongs to the library BACKNET.
   It is Copyright (C) 1995 Marko Meyer.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: mme@pub.th-zwickau.de
   Ordinary Mail: Marko Meyer
                  Teichstrasse 27
				  D-08289 Schneeberg
				  Germany
*/

#ifndef _NET_ERRORS
#define _NET_ERRORS

#include <dosbug.h>
#include __LIST_ER__

#define ERR_MEMORY_NEU 101 /*Not enough memory.*/
#define ERR_INITMD_NEU 102 /*Wrong init mode called.*/
#define ERR_UXPEOF_NEU 103 /*Unexpected EOF at reading GWI-File.*/
#define ERR_READWG_NEU 104 /*Error at reading GWI-File.*/
#define ERR_GWINOP_NEU 105 /*GWI-File not open!*/
#define ERR_SAVEWG_NEU 106 /*Error at writing to GWI-File.*/
#define ERR_WGTOVF_NEU 107 /*Weight-Overflow.*/
#define ERR_NOIDAT_NEU 108 /*No Init Data. (net_neuron only!) */
#define ERR_WRNVAL_NEU 109 /*No correct value given. (net_neuron only!)*/
#define ERR_NEUDES_NEU 110 /*No InfoStruct available. (net_neuron only!) */

#define ERR_WRACTN_LAY 1001 /*Wrong action number in Layer-function Action.*/
#define ERR_CRLIST_LAY 1002 /*Error at creating lists in layer.*/
#define ERR_NOLMAN_LAY 1003 /*No List Manager found.*/
#define ERR_NSINIT_LAY 1004 /*Neuro-Store init failed.*/
#define ERR_NONSTR_LAY 1005 /*No Neuro-Store active.*/
#define ERR_NONEUR_LAY 1006 /*Neuron could not be initialized.*/
#define ERR_NONSLS_LAY 1007 /*No Neuron Specific Input List Store available.
							  (Autoassociator only!) */

#define ERR_NOLMAN_NET 10001 /*No ListMan available.*/
#define ERR_NOILST_NET 10002 /*No InputList available.*/
#define ERR_NOLROU_NET 10003 /*No LernOutList available.*/
#define ERR_NOLERR_NET 10004 /*No LastErrList available.*/
#define ERR_NOLSTR_NET 10005 /*No Layer-Store available.*/
#define ERR_MEMORY_NET 10006 /*Not enough memory.*/
#define ERR_GWINOP_NET 10007 /*GWI-File not open.*/
#define ERR_READWG_NET 10008 /*Error at reading in GWI-file.*/
#define ERR_ETYNAR_NET 10009 /*NeuronCnt-Array is empty.*/
#define ERR_GWICOL_NET 10010 /*GWI-File and NNet don't fit (GWI-collision).*/
#define ERR_LDREAD_NET 10011 /*Error at reading Layer-Data.*/
#define ERR_NONAME_NET 10012 /*No Name found. (Action) */
#define ERR_NOIMST_NET 10013 /*MST-File not opened!*/
#define ERR_READMS_NET 10014 /*Error at reading in MST-file! */
#define ERR_MSTCOL_NET 10015 /*MST-File and NNet don't fit (MST-collision).*/
#define ERR_WRACTN_NET 10016 /*Wrong Action specified.*/
#define ERR_NOILRN_NET 10017 /*LRN-File not open.*/
#define ERR_NOOERR_NET 10018 /*ERR-File not open.*/
#define ERR_READLR_NET 10019 /*Error at reading LRN-File.*/
#define ERR_LRNCOL_NET 10020 /*LRN-File and NNet don't fit (LRN-collision).*/
#define ERR_WRTEER_NET 10021 /*Error at writing ERR-File.*/
#define ERR_BCOLIS_NET 10022 /*Collision between MST&LRN   (Big collision).*/
#define ERR_WRWHER_NET 10023 /*Wrong 'Where' given to Load_Pattern(...).*/
#define ERR_NOOOUT_NET 10024 /*OUT-File not open.*/
#define ERR_WRTOUT_NET 10025 /*Error at writing OUT-File.*/
#define ERR_CRTSAV_NET 10026 /*Error at creating GWI-Save.*/
#define ERR_TAKLAY_NET 10027 /*Error at taking Layer using Take_Layer(int).*/
#define ERR_NOASSL_NET 10028 /*No Autoassociator Layer found. 
							   (Autoassociator only!) */

#define ERR_MULTIP_NET 0xFFFF /*Multiple Errors occured.*/


/* The following are errors from the networked part. */

#define ERR_MEMORY_NWK 15000 /* Virtual memory exhausted. */
#define ERR_UKSVNM_NWK 15001 /* Unknown server name. */
#define ERR_USSNPO_NWK 15002 /* Unset port AND server name. */
#define ERR_NDSSUP_NWK 15003 /* Can't open stream socket. */
#define ERR_NBLCAD_NWK 15004 /* Can't bind address. */
#define ERR_UKEMTP_NWK 15005 /* Unknown emergency type. */
#define ERR_SNDEMR_NWK 15006 /* Error at sending emergency struct. */
#define ERR_TIMOUT_NWK 15007 /* A send/receive timed out. */
#define ERR_REQNIS_NWK 15008 /* Unsatisfied NISt-Request. */
#define ERR_NOCONN_NWK 15009 /* Can't connect. */
#define ERR_REQRDS_NWK 15010 /* Unsatisfied RDSt-Request. (ArrayServ only!) */
#define ERR_RCNTZR_NWK 15011 /* RDSt_Cnt as sent in RS is zero! (ArrayServ!) */
#define ERR_NOAUDP_NWK 15012 /* No address given at UDP send. */
#define ERR_SOCKNS_NWK 15013 /* Socket type not supported. */
#define ERR_UNKREQ_NWK 15014 /* Unknown RequestID. */

#define RET_CRTSEM_ARS 50    /* Error at create_sem [ArrayServer] */
#define RET_SHMGET_ARS 51    /* Error at shmget [ArrayServer] */
#define RET_SHMATT_ARS 52    /* Error at shmat [ArrayServer] */
#define RET_NOSOCK_ARS 53    /* Error at set_up_udp [ArrayServer] */
#define RET_NOFORK_ARS 54    /* Error at fork [ArrayServer] */
#define RET_DWNSEM_ARS 55    /* Error at down_sem [ArrayServer] */
#define RET_SHMDTH_ARS 56    /* Error at shmdt [ArrayServer] */
#define RET_SHMCTL_ARS 57    /* Error at shmctl [ArrayServer] */
#define RET_WUPSEM_ARS 58    /* Error at wakeup_sem [ArrayServer] */
#define RET_SIGCLD_ARS 59    /* Process received SIGCLD. [ArrayServer] */
#define RET_SIGINT_ARS 60    /* Process received SIGINT. [ArrayServer] */
#define RET_MKPIPE_ARS 61    /* Error at pipe [Array_Server] */
#define RET_RDPIPE_ARS 62    /* Error at read [Array_Server] */
#define RET_WRPIPE_ARS 63    /* Error at write [Array_Server] */
#endif /*_NET_ERRORS*/ 






