/* autotest.cc

   Simple test program for BACKNET.

   Author: Ralf Schmidt
   Date:   10.08.1995 (creation)
   Time-stamp: <96/02/01 10:27:27 rsc>

	BACKNET - A library for simulating neural BACKPROPAGATION-Networks
    Copyright (C) 1995	Ralf Schmidt

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	If you have any suggestions, ideas or comments regarding this library
	feel free to contact me:

	Email:	mme@pub.th-zwickau.de
	Ordinary Mail:	Marko Meyer
					Teichstrasse 27
					D-08289 Schneeberg
					F.R.G.
					
    Email:  rsc@informatik.th-zwickau.de
	Ordinary Mail:  Ralf Schmidt
	                Neuplanitzer Strasse 41
					D-08062 Zwickau
					Germany

	Changes:
	95/12/08 -- Marko Meyer: Incorporated nnet_aa-template-class.
	95/12/09 -- Marko Meyer: Took it back.
	96/01/03 -- Ralf Schmidt: changed the limits for equal 
*/

#include <backnet.h>
#include <net_errs.h>
#include <nnet_aa.h>
#include <signal.h>
#include <sys/time.h>
#include <unistd.h>
#include <math.h>

int Inquire_Neurons(int *i_Neu)
{
	
	*i_Neu=0;
	while((*i_Neu<1)||(*i_Neu>100))
	{
		cin.clear();
		cout<<"How many Neurons do you want in Layer 0 ? ";
		cin>>*i_Neu;
		if((*i_Neu<1)||(*i_Neu>100))
			cout<<"This amount ("<<*i_Neu<<") is not allowed!"<<endl;
	}
	
	return NO_ERROR;
}


int Inquire_Params(float* f_LRate,int* i_Mode,int *i_Minimum,
				   int *i_Maxcount,float *f_Equal,int *i_SelfBackCuppling)
{
	unsigned long int range;
	
	*f_LRate=0;
	while((*f_LRate<=0)||(*f_LRate>=1))
	{
		cin.clear();
		cout<<"Please choose a factor for learning (usually betw. 0 and 1)! ";
		cin>>*f_LRate;
		if((*f_LRate<=0)||(*f_LRate>=1))
			cout<<"Such a factor ("<<*f_LRate<<") is not allowed!"
				<<endl;
	}
	*i_Mode=-1;
	while((*i_Mode<0)||(*i_Mode>4))
	{
		cin.clear();
		cout<<"What's the InitMode of the Neurons?"<<endl;
		cout<<"Possible choices are:"<<endl;
		cout<<"\t0 - Init from GWI-File"<<endl;
		cout<<"\t1 - Init with uniform values between 0 and 1"<<endl;
		cout<<"\t2 - Init with uniform values between -1 and 1"<<endl;
		cout<<"\t3 - Init with all values set to 0"<<endl;
		cout<<"\t4 - Init with all values set to 1"<<endl;
		cout<<"Make your choice: ";
		cin>>*i_Mode;
		if((*i_Mode<0)||(*i_Mode>4))
			cout<<"You've chosen a not allowed mode("<<*i_Mode<<")."<<endl;
	}
	
		
	*i_Minimum=1;
	while((*i_Minimum!=-1)&&(*i_Minimum!=0))
	{
		cin.clear();
		cout<<"What is the minimum of the Hopfield-activity-function" 
			<<"of neurons?"<<endl;
		cout<<"Possible choices are -1 and 0 !"<<endl;
		cout<<"Make your choice: ";
		cin>>*i_Minimum;
		if((*i_Minimum!=-1)&&(*i_Minimum!=0))
			cout<<"This is not an allowed value: "<<*i_Minimum<<" !"<<endl;
	}
	
	
	*i_Maxcount=-1;
	
		
	range=2147483648;
		
	while((*i_Maxcount<(signed int) 1)||(*i_Maxcount>(signed int) (range)))
	{
		cin.clear();
		cout<<"Which maximal count of recalls shall be used?"<<endl;
		cout<<"Possible choices are all integer-values between 1 and "
			<<range<<" !"<<endl;
				
		cout<<"Make your choice: ";
		cin>>*i_Maxcount;
		if((*i_Maxcount<(signed int) 1)||(*i_Maxcount>(signed int) (range)))
			cout<<"This is not an allowed value ("<<*i_Maxcount<<")."<<endl;
	}
	
	*f_Equal=-1;
	while(*f_Equal<0)
	{
		cin.clear();
		cout<<"At which difference input- and output-values are equal?"<<endl;
		cout<<"Possible choices are all ELEMTYPE"
			<<"-values which are higher than 0"<<endl;
		cout<<"Make your choice: ";
		cin>>*f_Equal;
		if(*f_Equal<0)
			cout<<"This is not an allowed value ("<<*f_Equal<<")."<<endl;
	}
	
	
	*i_SelfBackCuppling=-1;
	
	while((*i_SelfBackCuppling!=1)&&\
		  (*i_SelfBackCuppling!=2))
	{
		cin.clear();
		cout<<"Do you want to allow or deny self couplings?"<<endl;
		cout<<"\t1 - Allow self couplings"<<endl;
		cout<<"\t2 - Deny self couplings"<<endl;
		cout<<"Your choice: ";
		cin>>*i_SelfBackCuppling;
		if((*i_SelfBackCuppling!=1)&&\
		   (*i_SelfBackCuppling!=2))
			cout<<"This is not allowed."<<endl;
	}
	switch(*i_SelfBackCuppling)
	{
		
	  case 1:
		*i_SelfBackCuppling=SelfBackCuppling_Allowed;
		break;
		
	  case 2:
		*i_SelfBackCuppling=SelfBackCuppling_Denied;
		break;
	}
		
		
				
	return NO_ERROR;
}

int Inquire_Name(char* s_Name)
{
	cin.clear();
	cout<<"You must now choose a name for the GWI-file."<<endl;
	cout<<"Your choice: ";
	cin>>s_Name;
	return NO_ERROR;
}

int Inquire_Patternfile(char* s_FileName)
{
	cin.clear();
	cout<<"Please input a name for the Patternfile: ";
	cin>>s_FileName;
	return NO_ERROR;
}

int Inquire_Action(int *i_Action)
{
	*i_Action=0;
	cin.clear();
	
	while((*i_Action<1)||(*i_Action>3))
	{
		cin.clear();
		cout<<"What Action do you want? Possible choices are:"<<endl;
		cout<<"\t1 - Learning"<<endl;
		cout<<"\t2 - Recalling"<<endl;
		cout<<"\t3 - Ending"<<endl;
		cout<<"Make your choice: ";
		cin>>*i_Action;
		if((*i_Action<1)||(*i_Action>3))
			cout<<"This Action ("<<*i_Action<<") is not allowed."<<endl;
	}
	
	/*if(*i_Action<3)
	{
		while((*i_SelfBackCuppling<SelfBackCuppling_Denied)||\
			  (*i_SelfBackCuppling>SelfBackCuppling_Allowed))
		{
			cin.clear();
			cout<<"Do you want to allow or deny self couplings?"<<endl;
			cout<<"\t1 - Allow self couplings"<<endl;
			cout<<"\t2 - Deny self couplings"<<endl;
			cout<<"Your choice: ";
			cin>>*i_SelfBackCuppling;
			if((*i_SelfBackCuppling<SelfBackCuppling_Denied)||\
			   (*i_SubAction>SelfBackCuppling_Allowed))
				cout<<"This is not allowed."<<endl;
		}
		switch(*i_SelfBackCuppling)
		{
			
		  case 1:
			*i_SelfBackCuppling=SelfBackCuppling_Allowed;
			break;
		
		  case 2:
			*i_SelfBackCuppling=SelfBackCuppling_Denied;
			break;
		}
		
		
	} */
	
	
	/**i_Action|=(i_SubAction*16); */
	return NO_ERROR;
}


int Inquire_Learn(int *i_Steps)
{
	*i_Steps=0;
	while(*i_Steps<=0)
	{
		cin.clear();
		cout<<"How many steps? ";
		cin>>*i_Steps;
		if(*i_Steps<=0) cout<<"Zero or less steps are not allowed!"<<endl;
	}
	return NO_ERROR;
}

/*int Inquire_Minimum(int *i_Min)
{
	*i_Min=0;
	cin.clear();
	cout<<"What's the minimum of the input data?";
	cin>>*i_Min;
	return NO_ERROR;
}
*/
/*int Inquire_RecLim(int *i_RecLimit)
{
	*i_RecLimit=0;
	cin.clear();
	cout<<"What's the minimum of recalls when learning? (0 for unlimited): ";
	cin>>*i_RecLimit;
	return NO_ERROR;
}*/

int main(void)
{
	char c_Change='y',*s_Name=NULL;
	int i_Neuro=0,i_InitMode,i_Minimum,i_Maxcount;
	float f_Learnrate,f_Equal;
	int i_LSteps,i_Action, /*i_Minimum_Input,i_RecLim,*/i_SelfBackCuppling;
	char *s_PatName,*s_RecPatName;
	ifstream I_Error;
	C_NNet_aa *MyNet;
	int i_NetError=NO_ERROR;
	struct timeval time1, time2;
	int hour, minute, second;
	
	cout<<"This is AUTOTEST. You are expected to answer the following" 
		<<"questions \n and follow the advises the program will give."<<endl;
	cout<<endl;

    while(c_Change=='y')
	{
		i_Neuro=0;
		Inquire_Neurons(&i_Neuro);
		Inquire_Params(&f_Learnrate,&i_InitMode,&i_Minimum,
					   &i_Maxcount,
					   &f_Equal,&i_SelfBackCuppling);
		//Inquire_Minimum(&i_Minimum_Input);
		//Inquire_RecLim(&i_RecLim);
		s_Name=(char*)new char[80];
		Inquire_Name(s_Name);
		cout<<"\f";
		cout<<"Okay, that's what you entered: "<<endl;
		cout<<"Your Net should have: "<<endl;
		cout<<"\t1 Layer with "<<i_Neuro<<" Neurons"<<endl;
		cout<<"\tLearnrate: "<<f_Learnrate<<endl;
		cout<<"\tInitMode : "<<i_InitMode<<endl;
		cout<<"\tMinimum  : "<<i_Minimum<<endl;
		cout<<"\tMaxcount  : "<<i_Maxcount<<endl;
		cout<<"\tEqual    : "<<f_Equal<<endl;
		cout<<"\tSelfBackCuppling: "
			<<((i_SelfBackCuppling==SelfBackCuppling_Allowed)?\
			   "Allowed":"Denied")<<endl;
		
		cout<<"\tFilename : "<<s_Name<<endl;
		//cout<<"\tMinimum of inputs : "<<i_Minimum_Input<<endl;
		cout<<endl;
	
		cout<<"That's all. Is there anything to change? (In case there is,\n"\
			<<"you have to enter new values for EVERYTHING!) ";
		cin>>c_Change;
	}
	cout<<"\f";
	cout<<"You entered lot's of values, now we will start to build up"
		<<"the Net!"<<endl;
	
	MyNet=(C_NNet_aa*)new C_NNet_aa(f_Learnrate,
									i_SelfBackCuppling,
									s_Name);
	i_NetError=MyNet->Init(i_Neuro,i_InitMode,i_Minimum,i_Maxcount,f_Equal);
	cout<<"The Net returned ";
	if(i_NetError==NO_ERROR)
		cout<<"NO Error."<<endl;
	else
		cout<<"Error "<<i_NetError<<"."<<endl;

	if(i_NetError==NO_ERROR)
	{
		cout<<endl;
		s_PatName=(char*)new char[80];
		s_RecPatName=(char*)new char[80];

		i_Action=ACTN_LEARN;
		while((i_Action & 0x0F)<=2)
		{
			Inquire_Action(&i_Action);
		
			if((i_Action & 0x0F)==ACTN_LEARN)	
			{	
				cout<<"We continue with learning."<<endl;
				do
				{
					Inquire_Patternfile(s_PatName);
				    Inquire_Learn(&i_LSteps);
					/* TIME */
					gettimeofday(&time1,NULL);
					i_NetError=MyNet->Action(i_Action,s_PatName,&i_LSteps);
					gettimeofday(&time2,NULL);
					/* TIME */
					hour=(time2.tv_sec-time1.tv_sec)/3600;
					minute=((time2.tv_sec-time1.tv_sec)%3600)/60;
					second=((time2.tv_sec-time1.tv_sec)%3600)%60;
					cout<<"Learning lasted: "<<endl
						<<"\t"<<hour<<" hours,\t"<<minute<<" minutes,\t"
							<<second<<" seconds."<<endl;
					cout<<"After learning the Net there is ";
					if(i_NetError==NO_ERROR)
						cout<<"NO Error."<<endl;
					else
						cout<<"Error "<<i_NetError<<"."<<endl;
					c_Change='n';
					if(i_NetError==NO_ERROR)
					{
						cout<<"Continue learning ? ";
						cin>>c_Change;
					}
					else return i_NetError;
				}
				while(c_Change!='n');
			}
			else
			if(i_Action==ACTN_RECAL)
			{
				cout<<"We continue with recalling!"<<endl;
				Inquire_Patternfile(s_RecPatName);
				i_NetError=MyNet->Action(i_Action,s_RecPatName,0);
				cout<<"After recalling the Net there is ";
				if(i_NetError==NO_ERROR)
					cout<<"NO Error."<<endl;
				else
					cout<<"Error "<<i_NetError<<"."<<endl;
			}
			else 
				cout<<"Good bye and have a nice day!"<<endl;
		}
		if(i_NetError==NO_ERROR)
		{
			MyNet->Save();
			delete MyNet;
			if(i_NetError!=NO_ERROR)
				cout<<"Error at the end is: "<<i_NetError<<endl;
		}
		else return i_NetError;
	}
	else return i_NetError;
	return i_NetError;
}


