/*
 * 
 * A coarse grammar for C++
 * This file is designed to be processed by the PCCTS utilities ANTLR and 
 * DLG to generate a scanner and parser for the cccc metric analyser project
 *
 * by Tim Littlefair, October 1995
 * 
 * $Log: cccc.g,v $
 * Revision 1.38  1997/07/24 12:09:15  cccc210
 * changes relating to parse of constructors with initializer lists
 *
 * Revision 1.37  1997/07/11 13:47:36  cccc210
 * returned to anonymous module concept
 *
 * Revision 1.36  1997/07/05 00:27:14  cccc210
 * *** empty log message ***
 *
 * Revision 1.35  1997/06/27 15:51:13  cccc210
 * *** empty log message ***
 *
 * Revision 1.34  1997/06/26 16:34:03  cccc210
 * resynchronisation working well
 *
 * Revision 1.33  1997/06/24 15:52:52  cccc210
 * *** empty log message ***
 *
 * Revision 1.32  1997/06/16 16:31:40  cccc210
 * *** empty log message ***
 *
 * Revision 1.31  1997/06/08 07:23:00  cccc210
 * *** empty log message ***
 *
 * Revision 1.30  1997/06/08 04:53:33  cccc210
 * *** empty log message ***
 *
 * Revision 1.29  1997/06/07 05:47:48  cccc210
 * *** empty log message ***
 *
 * Revision 1.28  1997/05/02 13:14:08  cccc210
 * added Java support
 *
 * Revision 1.27  1997/04/28 13:02:35  cccc210
 * before working on Java functionality
 *
 * Revision 1.26  1997/04/03 11:01:19  a6
 * version 2.06
 *
 * Revision 1.25  1997/03/29 11:56:45  a6
 * changes made by Bill McLean to help with some common C idioms
 * thanks Bill!
 *
 * Revision 1.24  1997/03/19 16:11:05  a6
 * fixed problems with C typedef struct { ... } NAME ;
 *
 * Revision 1.23  1997/03/19 12:43:00  a6
 * fixing initial user problems
 *
 * Revision 1.22  1997/03/02 07:58:52  a6
 * single output file now generated
 *
 * Revision 1.21  1997/02/27 17:03:46  a6
 * added rapid consume() processing in brace_block
 *
 * Revision 1.20  1997/02/23 04:36:38  a5
 * added semicolons after union and enum definitions
 *
 * Revision 1.19  1997/02/23 03:10:45  a5
 * version 2.0.0
 *
 * Revision 1.18  1997/02/15 06:03:14  a5
 * reverting to version 1.16
 *
 * Revision 1.16  1997/02/10 13:35:51  a5
 * added virtual inheritance, fixed semantic predicate over multiple lines
 *
 * Revision 1.15  1997/02/08 16:08:10  a5
 * getting very close
 *
 * Revision 1.14  1997/01/19 06:19:38  a5
 * fixed problems with comments before function brace, pure virtual functions
 *
 * Revision 1.13  1997/01/14 14:06:31  a5
 * got rid of cccc_rgh.{h,cc}
 *
 * Revision 1.12  1997/01/13 14:11:50  a5
 * handles most of MT's code so it must be OK
 *
 * Revision 1.11  1997/01/13 12:51:09  a5
 * added leading_comment between class header and brace bloc
 * (used for where inheritance list is commented out
 *
 * Revision 1.10  1997/01/12 00:57:03  a5
 * before going to MT's house
 *
 * Revision 1.9  1997/01/05 06:32:27  a5
 * checking in before starting work on balanced_list construct
 *
 * Revision 1.8  1996/12/31 13:04:34  a5
 * only remaining syntax error relates to comma in ccccmain.cc
 *
 * Revision 1.7  1996/12/31 06:22:59  a5
 * fixed SEGV problem?
 *
 * Revision 1.6  1996/12/30 08:01:50  a5
 * working version
 * core dump still present
 * many other problems fixed
 *
 * Revision 1.4  1996/11/15 13:27:07  a4
 * fixed the silly core dump
 *
 * Revision 1.3  1996/11/12 16:08:29  a4
 * *** empty log message ***
 *
 * Revision 1.2  1996/10/29 14:06:49  a4
 * work on recognition of initializers
 *
 * Revision 1.1  1996/10/27 16:14:08  a4
 * Initial revision
 *
 */

#header<<
  #include "cccc.h"
  #include "cccc_ast.h"
  #include "cccc_utl.h"

  // the objects which PCCTS creates for ASTs as the #0 variable etc
  // have type "pointer to ASTBase", which means they need to be cast
  // to a pointer to my variant of AST if I want to call my AST 
  // methods on them
  #define MY_AST(X) ( (AST*) X)
>>

#token Eof "@" << replstr("<EOF>"); >>

#token WHITESPACE "[\ \t\r]+" << skip(); >>
#token EOL "\n" << 
  if(ANTLRToken::bCodeLine != 0) {
    IncrementCount(tcCODELINES); 
    ANTLRToken::bCodeLine=0;
  }
  newline(); 
  skip(); 
>> 

/* preprocessor constructs - comments, #defines etc */

#token HASH "#" << mode(PREPROC); more(); >>
#lexclass PREPROC
#token P_EOL "\n" << newline(); mode(START); skip(); >>
#token P_LINECONT "\\\n" << ; skip(); >>
#token P_ANYTHING "~[\n]" << ; more(); >>
#token P_COMMULTI "/\*" << mode(COMMENT_MULTI); more(); skip(); >>
#lexclass START

/*
** The object oriented design editor Rational Rose/C++ generates source
** inserting directives into source files disguised as comments so that
** C++ source contributed by Rational Rose, which Rose is at liberty to
** change or overwrite can be distinguished from source code written by 
** the programmer, which Rose will do its best to preserve.
** We do not count these as user comments.
*/
#token RR_DIRECTIVE "//##" << mode(RR); skip(); >>
#lexclass RR
#token RR_ANYTHING "~[\n]" << skip(); >>
#token RR_END "\n" << mode(START); skip(); newline(); >>
#lexclass START

/*
** for some reason, the string //#define gives an invalid token error
** with //# quoted as the token name, the 'd' lost in space and 'efine'
** quoted as the next token.  For the time being we will just try to trap
** this here (NB we do not count this as a user comment)
*/
#token COMDEF "//#" << mode(COMMENT_LINE); skip(); >>
#token COMLINE "//" << mode(COMMENT_LINE); skip(); >>
#lexclass COMMENT_LINE
#token COMLINE_END  "\n" << 
  IncrementCount(tcCOMLINES); 
  newline(); 
  mode(START); 
  skip();
>>
#token COMLINE_ANYTHING "~[\n]" << skip(); >>
#lexclass START

#token COMMULTI "/\*" << mode(COMMENT_MULTI); skip(); >>
#lexclass COMMENT_MULTI
#token COMMULTI_END "\*/" << 
  IncrementCount(tcCOMLINES); 
  mode(START); 
  skip(); 
>>
#token COMMULTI_EOL "\n" << 
  IncrementCount(tcCOMLINES); newline(); skip(); 
>>
#token COMMULTI_ANYTHING "~[\n]" << skip(); >>
#lexclass START

#token STRINGCONST "\"" << mode(CONST_STRING); skip(); >>
#lexclass CONST_STRING
#token STRINGCONST "\"" << mode(START); >>
#token S_ANYTHING "~[\"]" << skip(); >>
#lexclass START

#token CHARSTART "\'" << mode(CONST_CHAR); skip(); >>
#lexclass CONST_CHAR
#token CHARCONST "'" << replstr("'.'"); mode(START); >>
#token CH_ANYTHING "~[']" << skip(); >>
#lexclass START


#token LBRACE "\{" << IncrementNesting(); >>
#token RBRACE "\}" << DecrementNesting(); >>
#token LPAREN "\(" << ; >>
#token RPAREN "\)" << ; >>
#token LBRACK "\[" << ; >>
#token RBRACK "\]" << ; >>


/* keywords */
#token ASM "asm" << ; >>
#token AUTO "auto" << ; >>
#token BREAK "break" << IncrementCount(tcMCCABES_VG); >>
#token CASE "case" << ; >>
#token CATCH "catch" << ; >>
#token CHAR "char" << ; >>
#token CLASS "class" << ; >>
#token CONST "const" << ; >>
#token CONTINUE "continue" << ; >>
#token DEFAULT "default" << ; >>
#token DELETE "delete" << ; >>
#token DO "do" << ; >>
#token DOUBLE "double" << ; >> 
#token ELSE "else" << ; >>
#token ENUM "enum" << ; >>
#token EXTERN "extern" << ; >>
#token FLOAT "float" << ; >>
#token FOR "for" << IncrementCount(tcMCCABES_VG); >>
#token FRIEND "friend" << ; >>
#token GOTO "goto" << ; >>
#token IF "if" << IncrementCount(tcMCCABES_VG); >>
#token INLINE "inline" << ; >>
#token INT "int" << ; >>
#token LONG "long" << ; >>
#token NEW "new" << ; >>
#token OPERATOR "operator" << ; >>
#token PRIVATE "private" << ; >>
#token PROTECTED "protected" << ; >>
#token PUBLIC "public" << ; >>
#token REGISTER "register" << ; >>
#token RETURN "return" << IncrementCount(tcMCCABES_VG); >>
#token SHORT "short" << ; >>
#token SIGNED "signed" << ; >>
#token SIZEOF "sizeof" << ; >>
#token STATIC "static" << ; >>
#token STRUCT "struct" << ; >>
#token SWITCH "switch" << IncrementCount(tcMCCABES_VG); >>
#token TEMPLATE "template" << ; >>
#token THIS "this" << ; >>
#token THROW "throw" << ; >>
#token TRY "try" << ; >>
#token TYPEDEF "typedef" << ; >>
#token UNION "union" << ; >>
#token UNSIGNED "unsigned" << ; >>
#token VIRTUAL "virtual" << ; >>
#token VOID "void" << ; >>
#token VOLATILE "volatile" << ; >>
#token WHILE "while" << IncrementCount(tcMCCABES_VG); >>

/* operators */

#token "==" << ; >>
#token "!=" << ; >>
#tokclass EQUAL_OP { "==" "!=" }

#token ASSIGN_OP "=" << ; >>

#token "\*=" << ; >> 
#token "\/=" << ; >> 
#token "%=" << ; >>
#token "\+=" << ; >>
#token "\-=" << ; >>
#token "\>\>=" << ; >>
#token "\<\<=" << ; >>
#token "&=" << ; >>
#token "\^=" << ; >>
#token "\|=" << ; >>
#tokclass OP_ASSIGN_OP 
	{ "\*=" "\/=" "%=" "\+=" "\-=" "\>\>=" "\<\<=" "&=" "\^=" "\|="	}
 
#token "\>\>" << ; >>
#token "\<\<" << ; >>
#tokclass SHIFT_OP { "\>\>" "\<\<" } 

#token GREATERTHAN "\>"  << ; >>
#token LESSTHAN "\<"  << ; >>
#token GREATEREQUAL "\>="  << ; >>
#token LESSEQUAL "\<="  << ; >>
#tokclass REL_OP { "\>" "\<" "\>=" "\<=" }
 
#token ASTERISK "\*" << ; >>

#token "\/" << ; >>
#token "%"  << ; >>
#tokclass DIV_OP { "\/" "%" } 

#token "\.\*" << ; >>
#token "\-\>\*" << ; >>
#tokclass PM_OP { "\.\*" "\->\*" } 

#token "\+\+" << ; >>
#token "\-\-" << ; >>
#tokclass INCR_OP { "\+\+" "\-\-" } 

#token "\+" << ; >>
#token "\-" << ; >>
#tokclass ADD_OP { "\+" "\-" } 

#token LOGICAL_AND_OP "&&" << IncrementCount(tcMCCABES_VG); >>
#token LOGICAL_OR_OP "\|\|" << IncrementCount(tcMCCABES_VG); >>
#token LOGICAL_NOT_OP "!" << ; >>
#token QUERY_OP "?" << IncrementCount(tcMCCABES_VG); >>

#token AMPERSAND "&" << ; >>
#token PIPE "\|" << ; >>
#token TILDA "\~" << ; >>
#tokclass BITWISE_OP { "&" "\|" "\~" } 

#token COLONCOLON "::" << ; >>
#token ARROW "\-\>" << ; >>
#token COLON ":" << ; >>
#token PERIOD "\." << ; >>
#token COMMA "," << ; >>
#token SEMICOLON ";" << ; >>

/*
** draft ANSI C++ keywords 
**
** this grammar is intended to look forward to ANSI C++, so we at least
** try to lex up the new keywords (taken from the revised appendix to the
** ARM, which claims to cover decisions up to February 1995)
**
** namespaces will be treated as a kind of module, along with class and struct
**
** most of the other keywords will make little difference except
** that they will not be recognized as identifiers
** in general, anyone who is using these keywords as identifiers today, 
** probably shouldn't be
** 
** most of the rest of the new keywords occur in contexts where we aren't
** looking to hard (e.g. in procedural code rather than declaration or
** definition signatures)
*/
#token NAMESPACE "namespace" << ; >>
#token USING "using" << ; >>
#token AND "and" << ; >>
#token AND_EQ "and_eq" << ; >>
#token BITAND "bitand" << ; >>
#token BITOR "bitor" << ; >>
#token COMPL "compl" << ; >>
#token NOT "not" << ; >>
#token OR "or" << ; >>
#token OR_EQ "or_eq" << ; >>
#token XOR "xor" << ; >>
#token XOR_EQ "xor_eq" << ; >>
#token BOOL "bool" << ; >>
#token BTRUE "true" << ; >>
#token BFALSE "false" << ; >>
#token STATIC_CAST "static_cast" << ; >>
#token REINTERPRET_CAST "reinterpret_cast" << ; >>
#token CONST_CAST "const_cast" << ; >>
#token DYNAMIC_CAST "dynamic_cast" << ; >>
#token TYPEID "typeid"

 
/* identifiers */
#token IDENTIFIER "[A-Za-z_][A-Za-z_0-9]*" 
 << 
	// if the user has defined a file in the library directory 
	// called cccc_ign.dat, it is a list of identifiers to be 
	// ignored
	// this file is loaded into the global array skip_identifiers,
	// and every identifier we match is compared with each element
	// in the array
	int i;
	for(i=0; i<SKIP_IDENTIFIERS_ARRAY_SIZE; i++)
	{
		if(skip_identifiers[i]==NULL)
		{
			break;
		}
		else if(strcmp(lextext(),skip_identifiers[i]) == 0)
		{
			skip();
			break;
		}
	}
	
; >>

/* Literal elements - integer and float numbers and strings */

#lexclass START
#token OCT_NUM "[0][0-7]*"
#token L_OCT_NUM "[0][0-7]*[Ll]"
#token INT_NUM "[1-9][0-9]*"
#token L_INT_NUM "[1-9][0-9]*[Ll]"
#token HEX_NUM "[0][Xx][0-9A-Fa-f]+"
#token L_HEX_NUM "[0][Xx][0-9A-Fa-f]+[Ll]"
#token FNUM "([1-9][0-9]*{.[0-9]*} | {[0]}.[0-9]+) {[Ee]{[\+\-]}[0-9]+}"

#token ANYTHING "~[\{\}\[\]\(\)@]" << skip(); >>

// it is not obvious from the PCCTS documentation that it a token class
// may contain things already declared as tokens, but it does not appear
// to cause problems
#tokclass RESYNCHRONISATION { "\}" ";" } 

class CParser {

<<

ParseUtility ps;

void tracein(char *rulename)  { ps.tracein(rulename,guessing,LT(1)); }
void traceout(char *rulename)  { ps.traceout(rulename,guessing,LT(1)); }
void syn(
  _ANTLRTokenPtr tok, ANTLRChar *egroup, SetWordType *eset,
  ANTLRTokenType etok, int k) 
{ 
  if(DebugMask&PARSER) { ps.syn(tok); }
}

public:

void init (char* filename) 
{ 
	ps.reset(this);
	ps.set_string(pssFILE, filename); 
	ANTLRParser::init();
}

>>


/* 
** the start symbol for the grammar:
*/

start :
	  (link_item)* Eof
	; 

link_item! : 
<< 
	ParseUtility saved_ps=ps; 
>>
	  (EXTERN STRINGCONST LBRACE)? 
	  extern_linkage_block
	| { linkage_qualifier } definition_or_declaration
	<< 
		ps=saved_ps;
	>>  
	;

definition_or_declaration : 
	<<
	  // get ready in case we need to resynchronize...
          ANTLRTokenPtr initial_token=LT(1);
	  CCCC_String initial_text=ps.lookahead_text(3);
	>>
	  typedef_definition
	| ( scoped_member_name LPAREN )? 
	  method_declaration_or_definition_with_implicit_type
	| ( indirect_type scoped_member_name LPAREN )? 
	  method_declaration_or_definition_with_explicit_type
	| ( indirect_type scoped_member_name )?
	  instance_declaration
	| template_declaration_or_definition
	| class_declaration_or_definition
	| union_definition
	| enum_definition
	;
<<
{
  ANTLRTokenPtr resync_token;
  int resync_nesting=mytoken(initial_token)->getNestingLevel();
  ps.resynchronize(resync_nesting,RESYNCHRONISATION_set,resync_token);

  cerr << "Syntax error: parser failed to handle "
       << initial_text << "..." << resync_token->getText()
	<< " on lines " << initial_token->getLine() 
	<< " to " << resync_token->getLine() << endl;

  // now we build an AST representing the rejected area...
  initial_token->setText(initial_text);
  AST *rejected_ast=new AST(initial_token);
  AST *rejected_ast_end=new AST(resync_token);
  rejected_ast->setRight(rejected_ast_end);
  ps.record_rejected_extent(rejected_ast);
  
  // we only delete the root tree - it deletes the other one
  delete rejected_ast;
}
>>

// the following rule is included to cause generation of a token class
// which will be passed to the resynchronise() function
// it is not intended to be matched within the grammar
resync_tokens : 
	  RBRACE
	| SEMICOLON
	;

extern_linkage_block :
	  EXTERN STRINGCONST LBRACE (link_item)* RBRACE
	;

class_declaration_or_definition :
	  class_prefix sfx:class_declaration_or_definition_suffix
        <<
		if(file_language==lCPLUSPLUS)
		{
			if(#sfx == NULL)
			{
				// can't do much
			}
			else if(MY_AST(#sfx)->token.getType() == SEMICOLON)
			{
                		ps.set_string(pssDESCRIPTION,"declaration");
                		ps.record_module_extent(MY_AST(#0),utDECLARATION);
			}
			else
			{
                        	ps.set_string(pssDESCRIPTION,"definition");
				ps.record_module_extent(MY_AST(#0),utDEFINITION);
	 		}
		}
        >>
	;

class_declaration_or_definition_suffix :
	  SEMICOLON  
	| { inheritance_list! } class_block SEMICOLON 
        ;

union_definition :
	  UNION id:IDENTIFIER brace_block SEMICOLON
	<<
		ps.set_string(pssMODTYPE,"union");	
		ps.set_string(pssMODULE,$id->getText());
		ps.set_string(pssDESCRIPTION,"definition");
		ps.record_module_extent(MY_AST(#0),utDEFINITION);
	>>
	;


enum_definition :
	  ENUM id:IDENTIFIER brace_block SEMICOLON
	<<
		ps.set_string(pssMODTYPE,"enum");	
		ps.set_string(pssMODULE,$id->getText());
		ps.set_string(pssDESCRIPTION,"definition");
		ps.record_module_extent(MY_AST(#0),utDEFINITION);
	>>
	;

/*
** instance_declaration embraces declarations which initialise the variable
** as the same declaration may initialise some variables but not others,
** so we do not have a separate instance_definition rule
*/
instance_declaration :
	  direct_type { angle_block } instance_item ( COMMA instance_item )* SEMICOLON
	;

class_block :
	  << 
	      int saved_visibility=ps.get_flag(psfVISIBILITY);
	  >>
	  LBRACE class_block_item_list RBRACE
	  << ps.set_flag(psfVISIBILITY,saved_visibility); >>
	;

class_block_item_list :
	  (class_block_item)? class_block_item class_block_item_list
	| /* empty */
	;

class_block_item :
	  ( access_modifier )?
	| opt_friend_or_virtual_qualifier link_item
	;

opt_friend_or_virtual_qualifier! :
	  FRIEND 
        | VIRTUAL           << ps.set_flag(psfVIRTUAL,abTRUE); >> 
	| /* empty */
	;
	
access_modifier! :
	  access_key COLON
	;

method_declaration_or_definition_with_implicit_type :
	  method_signature method_suffix
	<<
		if(#2 == NULL)
		{
			// can't do anything
			cerr << "method item misparsed" << endl;
		} 
		else 
		{
			switch(MY_AST(#2)->token.getType())
			{
				case  SEMICOLON:
				{
					ps.set_string(pssDESCRIPTION,"declaration");
					ps.record_function_extent(MY_AST(#0),utDECLARATION);
				}
				break;

				case LBRACE:
				case ASSIGN_OP:
				{
 	        		ps.set_string(pssDESCRIPTION,"definition");
        			ps.record_function_extent(MY_AST(#0),utDEFINITION);
				}
				break;

				default:	
				{
					cout << "unexpected token in method item" << endl;
				}
			}
		}
		delete MY_AST(#0);
		#0=NULL;
	>>
	;

method_declaration_or_definition_with_explicit_type :
	  indirect_type method_declaration_or_definition_with_implicit_type 
	;

method_suffix :
	  SEMICOLON
	| ASSIGN_OP LITERAL_INTEGER SEMICOLON
	| {ctor_init_list!} brace_block
	;

method_signature :
	  scoped_member_name param_list opt_const_modifier
	;

indirect_type :
	  direct_type indir_op_list
	<<
		// this sets a string to the type name qualified with
		// any indirection operators present
		// this form of type specification is used in representing
		// the name of a variable or function
		ps.set_string(pssITYPE,MY_AST(#0)->canonical_name());
	>>
	;

direct_type :
	  type_qualifier_list! base_type
	<<
		// this sets a string to the unqualified type name, stripped
		// of all qualifiers and indirection
		// this form of type specification is used for defining
		// the supplier in a use relationship
		ps.set_string(pssUTYPE,MY_AST(#0)->canonical_name()); 
		delete MY_AST(#1); 
	>>
	;

scoped_member_name :
          ( explicit_scope_spec )?
	  explicit_scope_spec scoped_member_name 
	| unscoped_member_name
	<< 
		ps.set_string(pssMEMBER,MY_AST(#0)->canonical_name());

		// we distinguish between value & reference by
		// looking at the length of the string of indirection
		// operator associated with the last recognised type
		CCCC_String indir=ps.get_string(pssINDIR);
		if(strlen(indir)!=0)
		{
			// there is some indirection
			ps.set_string(pssDESCRIPTION,"return by reference");
			ps.record_userel_extent(MY_AST(#0),utPARBYREF);
		} else {
			// there is no indirection
			ps.set_string(pssDESCRIPTION,"return by value");
			ps.record_userel_extent(MY_AST(#0),utPARBYVAL);
		} 
	>>
	;

explicit_scope_spec :
	  cl:class_name {angle_block} COLONCOLON!
	<<
		ps.set_string(pssMODULE,MY_AST(#cl)->canonical_name());
		ps.set_flag(vDONTKNOW);
	>>
	;

unscoped_member_name :
	  IDENTIFIER 
	| dtor_member_name 
	| operator_member_name 
	;

dtor_member_name :
	  TILDA IDENTIFIER
	;

operator_member_name :
	  ( OPERATOR new_or_delete LBRACK RBRACK )?
	| ( OPERATOR new_or_delete )?
	| ( OPERATOR op )?
	| OPERATOR indirect_type
	;

new_or_delete :
	  NEW
	| DELETE
	;

param_list : 
	<< 
	  CCCC_String saved_itype;
	  saved_itype=ps.get_string(pssITYPE);
	>>
	  ( LPAREN param_item ( COMMA param_item )* RPAREN )?
	<<
	        ps.set_string(pssITYPE,saved_itype);
		ps.set_string(pssPARAMS,MY_AST(#0)->canonical_name());
	>>
	| paren_block
	<<
		ps.set_string(pssPARAMS,MY_AST(#0)->canonical_name());
	>>
	;

param_item :
	  param_type param_spec! 
	<<
		delete MY_AST(#2);
	>>
	;

param_type :
	  indirect_type 
	<<
		// we distinguish between value & reference by
		// looking at the length of the string of indirection
		// operator associated with the last recognised type
		CCCC_String indir=ps.get_string(pssINDIR);
		if(strlen(indir)!=0)
		{
			// there is a difference => some indirection
			ps.set_string(pssDESCRIPTION,"pass by reference");
			ps.record_userel_extent(MY_AST(#0),utPARBYREF);
		} else {
			// no difference => no indirection
			ps.set_string(pssDESCRIPTION,"pass by value");
			ps.record_userel_extent(MY_AST(#0),utPARBYVAL);
		}
	>>
	;

param_spec :
	  { IDENTIFIER } { "=" literal }
	;

opt_const_modifier :
	  ( CONST )?
	<<
		ps.set_flag(psfCONST,abTRUE);
	>>
	|
	/* empty */
	<<
		ps.set_flag(psfCONST,abFALSE);
	>>
	;

typedef_definition :
	   ( template_typedef_definition )?
	|  ( fptr_typedef_definition )?
	|  simple_typedef_definition
	;

template_typedef_definition :
	  TYPEDEF tn:IDENTIFIER angle_block simple_type_alias SEMICOLON
	<<
	    // by the time we get here, string[pssMODULE] should contain the
	    // name of the type alias, and string[pssUTYPE] and 
	    // string[pssITYPE] should contain the name of the type over which
	    // instantiation has been done, respectively with and without 
	    // indirection
	    
	    // first we record the existence of the typedef type
	    ps.set_string(pssMODTYPE,"typedef");
	    ps.record_module_extent(MY_AST(#0),utDEFINITION);

	    // then we record the relationship between this type and the
	    // specific type which replaces the generic one in the 
	    // template
	    ps.set_string(pssDESCRIPTION,"template type");
	    ps.record_userel_extent(MY_AST(#0),utTEMPLATE_TYPE);

	    // finally we record the relationship between the new type 
	    // and the template itself
	    ps.set_string(pssUTYPE,$tn->getText());
	    ps.set_string(pssITYPE,$tn->getText());
	    ps.set_string(pssDESCRIPTION,"template name");
	    ps.record_userel_extent(MY_AST(#0),utTEMPLATE_NAME);
	>>
	; 

fptr_typedef_definition :
	   TYPEDEF indirect_type fptr_type_alias SEMICOLON 
	;

simple_typedef_definition :
	  TYPEDEF indirect_type simple_type_alias SEMICOLON
	;

simple_type_alias :
	  id:IDENTIFIER
	<<
	    ps.set_string(pssMODULE,$id->getText());
	>>
	;

fptr_type_alias :
	  LPAREN ASTERISK indirect_type RPAREN paren_block 
	;

template_declaration_or_definition :
	  TEMPLATE { angle_block } class_or_method_declaration_or_definition
	;

class_or_method_declaration_or_definition :
	  (class_key)? class_declaration_or_definition 
	| (scoped_member_name LPAREN)?
	  method_declaration_or_definition_with_implicit_type
	| method_declaration_or_definition_with_explicit_type 
	;

class_prefix :
	  ( class_key! IDENTIFIER angle_block )?
	  class_key! id:IDENTIFIER angle_block 
	<<
		ps.set_string(pssMODULE,$id->getText());
		delete MY_AST(#2);
	>>
	| class_key! IDENTIFIER 
	<<
		ps.set_string(pssMODULE,MY_AST(#2)->canonical_name());
		delete MY_AST(#1);
	>>
	;

inheritance_list :
	  << ps.set_flag(vPRIVATE); >>
	  COLON inheritance_item_list 
	;

inheritance_item_list :
	  inheritance_item ( COMMA inheritance_item)*
	;

inheritance_item :
	  { VIRTUAL } { access_key } IDENTIFIER
	<<
		ps.set_string(pssDESCRIPTION,"inheritance");
		ps.set_string(pssUTYPE,MY_AST(#3)->canonical_name());
		ps.record_userel_extent(MY_AST(#0),utINHERITS);
	>>
	;
	
class_key :
        (
	    CLASS << ps.set_flag(vPRIVATE); >>
	  | STRUCT << ps.set_flag(vPUBLIC); >>
        )
	<<
		ps.set_string(pssMODTYPE,MY_AST(#0)->canonical_name());
	>>
	;

access_key :
	  PUBLIC! 
	  << 
		ps.set_flag(vPUBLIC); 
	  >>
        | PRIVATE! 
	  << 
		ps.set_flag(vPRIVATE); 
	  >>
        | PROTECTED! 
	  << 
		ps.set_flag(vPROTECTED); 
	  >>
	;

ctor_init_list : 
	<< 
		// we need to save the parse state as the rules used
		// for individual initialisers can change some of the
		// strings
	  	ParseUtility saved_ps=ps;
	>>
	  COLON ctor_init_item_list
	<< ps=saved_ps; >>
	;

ctor_init_item_list :
	  ( ctor_init_item COMMA )? ctor_init_item COMMA ctor_init_item_list
	| ctor_init_item
	;

ctor_init_item :
	  instance_item
	;


type_qualifier_list :
	  (type_qualifier)? type_qualifier type_qualifier_list
	| /* empty */
	;

// we are most interested in type qualifiers as they apply to methods
// leading static and virtual qualifiers relate to the method
// but a leading const modifier belongs to the return type, so we 
// ignore it
type_qualifier :
	  AUTO 
	| REGISTER 
	| CONST 
        | VOLATILE
	;

linkage_qualifier :
          STATIC            << ps.set_flag(psfSTATIC,abTRUE); >>
	| ( EXTERN STRINGCONST )?
        | EXTERN            
	| INLINE
	;

indir_op_list :
	(
	  ( AMPERSAND )? AMPERSAND indir_op_list
	| ( ASTERISK )? ASTERISK indir_op_list
	| /* empty */
	)
 	<<
		// we hold a string of the indirection operators associated
		// with the most recently described type
		// our prime use for this string is to use its length
		// to distinguish relationships by reference from those
		// by value
		ps.set_string(pssINDIR,MY_AST(#0)->canonical_name());
	>>
	;

base_type :
	  predefined_type
	| user_type
	;

user_type :
	  class_key identifier_or_brace_block_or_both
	| UNION identifier_or_brace_block_or_both
	| ENUM identifier_or_brace_block_or_both
	| class_name
	;

class_name :
	  ( IDENTIFIER angle_block! )?
	| IDENTIFIER
	;

identifier_or_brace_block_or_both :
	  IDENTIFIER opt_brace_block 
	;

opt_brace_block :
	 ( brace_block )?
	| /* empty */
	;

predefined_type :
	/* float types */
	  FLOAT 
	| DOUBLE 
	| ( LONG DOUBLE )? 
	/* integer types with all possible qualifiers */
	|  ( qualified_builtin_int_type )?
	/* the qualifiers themselves with implicit INT */
        | nonempty_int_qualifier_list 
	| VOID
	| BOOL
	;

int_qualifier :
	   UNSIGNED | SIGNED | LONG | SHORT
	;

qualified_builtin_int_type :
	  (int_qualifier)? int_qualifier qualified_builtin_int_type
	| INT
	| CHAR
	;

nonempty_int_qualifier_list :
	  (int_qualifier nonempty_int_qualifier_list)?
	| int_qualifier
	;

instance_item :
	  item_specifier brack_list opt_initializer
	<<
		CCCC_String indir=ps.get_string(pssINDIR);
		if(strlen(indir)!=0)
		{
			ps.set_string(pssDESCRIPTION,"has by reference");
			ps.record_userel_extent(MY_AST(#0),utHASBYREF);
		} else {
			ps.set_string(pssDESCRIPTION,"has by value");
			ps.record_userel_extent(MY_AST(#0),utHASBYVAL);
		}
	>> 
	;

item_specifier :
          LPAREN indir_op_list scoped_member_name RPAREN paren_block
	| indir_op_list scoped_member_name
	;

opt_initializer:
	  "=" indir_op_list init_value
	| paren_block
	| /* empty */
	;

init_value:
	  constant
	| brace_block
	| paren_block
	;

keyword :
	  ASM | AUTO | BREAK | CASE | CATCH | CHAR | CLASS | CONST 
	| CONTINUE | DEFAULT | DELETE | DOUBLE | DO | ELSE | ENUM | EXTERN 
	| FLOAT | FOR | FRIEND | GOTO | IF | INLINE | INT | LONG | NEW 
	| OPERATOR | PRIVATE | PROTECTED | PUBLIC | REGISTER | RETURN 
	| SHORT | SIGNED | SIZEOF | STATIC | STRUCT | SWITCH | TEMPLATE 
	| THIS | THROW | TRY | TYPEDEF | UNION | UNSIGNED | VIRTUAL 
	| VOID | VOLATILE | WHILE 
	| BOOL
	;

op :
	  EQUAL_OP | ASSIGN_OP | OP_ASSIGN_OP | SHIFT_OP | REL_OP 
	| ASTERISK | DIV_OP | PM_OP | INCR_OP | ADD_OP | QUERY_OP
	| LOGICAL_AND_OP | LOGICAL_OR_OP | LOGICAL_NOT_OP | BITWISE_OP 
	| COLONCOLON | COLON | PERIOD | ARROW | COMMA 
	;

constant :
	  literal
	| IDENTIFIER
	;

literal :
	  STRINGCONST | CHARCONST | FNUM
	| OCT_NUM | L_OCT_NUM | HEX_NUM | L_HEX_NUM | INT_NUM | L_INT_NUM
	;

block :
	  brace_block
	| brack_block
	| paren_block
	;

balanced :
	  scoped 
	| block
	| SEMICOLON
	;

balanced_list :
	  ( balanced )? balanced balanced_list
	| /* empty */
	;

nested_token_list [ int nl ] :
	  nested_token[nl] nested_token_list[nl]
	| /* empty */
	;

nested_token [ int nl ] : << ANTLRTokenPtr la_ptr=LT(1); >>
	<< (la_ptr!=0) && (mytoken(la_ptr)->getNestingLevel() > nl) >>?
	  tok:.
	;


scoped :
	  ( keyword )?
	| op
	| IDENTIFIER
	| literal
	;

brace_block : << int brace_level=MY_TOK(LT(1))->getNestingLevel(); >> 
	  LBRACE skip_until_matching_rbrace[brace_level]
	;

skip_until_matching_rbrace [ int brace_level ] :
<< 
	// this is an init action, so it should be executed unconditionally
	// when we try to match this rule
	while(MY_TOK(LT(1))->getNestingLevel()>=brace_level)
	{
	  if(LT(1)->getType()==Eof)
          {
	    // We have reached the end of file with unbalanced {} nesting.
	    // Presumably somebody stuffed up.  Maybe a preprocessor problem.
	    // Anyway, get out of this rule.  Expect a syntax error RSN.
	    break;
	  }
	  else
	  {
            if( 
	      (file_language==lANSIC) &&
              (LT(1)->getType()==IDENTIFIER) &&
              (LT(2)!=NULL) &&
              (LT(2)->getType()==LPAREN)
            )
            {
              // for ANSI C the only type of use relationship
              // we are able to recognize is invocation of a function
	      // as the scoping in C is simple, there is no danger of 
              // our misconstruing which module is the supplier
              ps.set_string(pssUTYPE,LT(1)->getText());
	      AST temp_ast(LT(1));
              ps.record_userel_extent(&temp_ast,utINVOKES);
            }
	    consume();
	  }
	}
>>
	RBRACE
	; 

paren_block :
	  LPAREN balanced_list! RPAREN 
	<< delete MY_AST(#2); >>
	;

brack_block :
	  LBRACK balanced_list! RBRACK 
	<< delete MY_AST(#2); >>
	;

brack_list :
          ( brack_block )? brack_block brack_list
        | /* empty */
        ;



angle_balanced_list :
	  ( ~ GREATERTHAN )*
	;

angle_block : 
	  LESSTHAN angle_balanced_list! GREATERTHAN
	<< delete MY_AST(#2) ; >>
	;
}


#token TOKENTYPE_MAX












