// -*- C++ -*-
/*
 * Fuzzy Rules Compiler
 *
 * $Id: fuzzymain.c,v 0.30 1996-08-01 21:15:28+02 steppler Exp $
 *
 * main
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define PROGRAM "CNfrc"

#define MAXPATH 128


FILE *hfile;
FILE *cfile;
FILE *in;
char *in_name;


char output[MAXPATH] = "Fuzzy";
char buf[MAXPATH];

extern char *optarg;
extern int optind;

extern int yyparse();
extern FILE *yyin;



void open_in()
{
    if(!strcmp(in_name, "-"))
    {
	in = stdin;
	in_name = "stdin";
    }
    else if((in = fopen(in_name, "r")) == NULL)
    {
	fprintf(stderr, "%s: can't open %s for reading\n", PROGRAM, in_name);
	exit(1);
    }
    yyin = in;
}

void close_in()
{
    fclose(in);
}




void open_hfile()
{
    sprintf(buf, "%s.h", output);
    if((hfile = fopen(buf, "w")) == NULL)
    {
	fprintf(stderr, "%s: can't open %s for writing\n", PROGRAM, buf);
	exit(1);
    }
    fprintf(hfile, "// -*- C++ -*-\n");
    fprintf(hfile, "/*\n");
    fprintf(hfile, " * Automatically generated from %s\n", in_name);
    fprintf(hfile, " *\n");
    fprintf(hfile, " * Do not edit !!!\n");
    fprintf(hfile, " */\n\n");
    fprintf(hfile, "#include <CNCL/FRuleBase.h>\n");
    fprintf(hfile, "#include <CNCL/FSet.h>\n");
    fprintf(hfile, "#include <CNCL/FSetTrapez.h>\n");
    fprintf(hfile, "#include <CNCL/FSetTriangle.h>\n");
    fprintf(hfile, "#include <CNCL/FVar.h>\n\n");
}

void close_hfile()
{
    fprintf(hfile, "};\n");

    fclose(hfile);
}



void open_cfile()
{
    sprintf(buf, "%s.c", output);
    if((cfile = fopen(buf, "w")) == NULL)
    {
	fprintf(stderr, "%s: can't open %s for writing\n", PROGRAM, buf);
	exit(1);
    }
    fprintf(cfile, "// -*- C++ -*-\n");
    fprintf(cfile, "/*\n");
    fprintf(cfile, " * Automatically generated from %s\n", in_name);
    fprintf(cfile, " *\n");
    fprintf(cfile, " * Do not edit !!!\n");
    fprintf(cfile, " */\n\n");
    fprintf(cfile, "#include \"%s.h\"\n\n", output);
}

void close_cfile()
{
    fprintf(cfile, "};\n");

    fclose(cfile);
}



void usage()
{
    fprintf(stderr, "usage: %s [-o output] rules\n", PROGRAM);
    exit(1);
}



int main(int argc, char *argv[])
{
#ifndef __linux__
    int c;

    while (1)
    {
	c = getopt(argc, argv, "o:");
        if (c  == EOF)
	    break;
	switch(c)
	{
	case 'o':
	    strcpy(output, optarg);
	    break;
	default:
	    usage();
	    break;
	}
    }
    

    if(optind != argc-1)
	usage();
#else
    if (argc != 2 && argc != 4)
    {
	usage();
    }
    else if (argc == 2)
    {
	optind = 1;
    }
    else
    {
	if (!strcmp(argv[1], "-o"))
	{
	    strcpy(output, argv[2]);
	    optind = 3;
	}
	else if (!strcmp(argv[2], "-o"))
	{
	    strcpy(output, argv[3]);
	    optind = 1;
	}
	else
	{
	    usage();
	}
    }
#endif

    in_name = argv[optind];

    open_in();
    open_hfile();
    open_cfile();

    yyparse();

    close_hfile();
    close_cfile();
    close_in();

    exit(0);
}
