/*
 * Fuzzy Rules Compiler
 *
 * $Id: fuzzysubs.h,v 0.29 1995/07/05 12:47:06 cncl-adm Exp $
 *
 * fuzzysubs.h - list management routines (include file)
 */

/* Structure for list entries */
struct Node 
{
    struct Node *next;
    void        *data;
};

/* Structure for lists (single-linked lists) */
struct List 
{
    struct Node *head;
    struct Node *tail;
};

/* Function prototypes */
void         add(struct List *, struct Node *);
struct Node *findname(struct List *, char *);
struct Node *newnode(long, void *);
struct Node *addnewname(struct List *, long, char *);
void         freelist(struct List *);
void         freenamelist(struct List *);
