//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: CNCL.h,v 0.32 1996-08-07 17:54:23+02 steppler Exp $
 *
 * CNClass: CNCL --- Top level class with settings and error handling
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 ****************************************************************************/

#ifndef __CNCL_h
#define __CNCL_h

/*
 * Library configuration
 */
#include <CNCL/config.h>


class ostream;
class ostrstream;


/*
 * NIL for Null pointer
 */
#define NIL 0

/*
 * builtin type `bool', really builtin if CNCL_HAS_BOOL defined
 */
#ifdef FALSE
# undef FALSE
#endif
#ifdef TRUE
# undef TRUE
#endif

#if CNCL_HAS_BOOL
# define FALSE	false
# define TRUE	true
#else
  typedef int bool;
# define FALSE	0
# define TRUE	1
# ifndef false
#  define false FALSE
# endif
# ifndef true
#  define true  TRUE
# endif
#endif

/*
 * Error return
 */
#define CNERROR	(-1)



/*
 * The top-level class of the CNCL hierarchie:
 *   -  error handling
 *   -  general settings
 */
class CNCL
{
  public:
    // Error handler settings
    enum ErrorType { err_fatal, err_abort, err_warning,
		     err_ignore, err_default, err_info };

  private:
    static ErrorType error_flag;
    static void (*exit_handler)();
    static bool initialized;
    static void new_handler();
    static char       *str_buf;
    static ostrstream *str_stream;
    static void clear();
    enum { STR_BUF_SIZE=8192 };
    
  public:
    // Constructor calls initialize()
    CNCL() { if(!initialized) initialize(); }
    
    // Virtual destructor
    virtual ~CNCL() {}

    // Initialize CNCL
    static void initialize();

    // Set/get error handler setting
    static ErrorType get_error();
    static ErrorType set_error(ErrorType new_error);

    // Set function called for terminating program
    static void set_exit_handler(void (*func)());
    // Default exit handler
    static void default_exit_handler();
    
    // Error handler functions
    static void error  (const char *msg1=NIL, const char *msg2=NIL,
			const char *msg3=NIL, const char *msg4=NIL,
			const char *msg5=NIL, const char *msg6=NIL );
    static void fatal  (const char *msg1=NIL, const char *msg2=NIL,
			const char *msg3=NIL, const char *msg4=NIL,
			const char *msg5=NIL, const char *msg6=NIL );
    static void warning(const char *msg1=NIL, const char *msg2=NIL,
			const char *msg3=NIL, const char *msg4=NIL,
			const char *msg5=NIL, const char *msg6=NIL );
    static void info   (const char *msg1=NIL, const char *msg2=NIL,
			const char *msg3=NIL, const char *msg4=NIL,
			const char *msg5=NIL, const char *msg6=NIL );
    static void error  (ErrorType err,
			const char *msg1=NIL, const char *msg2=NIL,
			const char *msg3=NIL, const char *msg4=NIL,
			const char *msg5=NIL, const char *msg6=NIL );

    // Stream for additional output after error(), ...
    static ostream& msg();
};


/*
 * Compatibility macro for old classes' cast_from_object(), using
 * test_flag(type_check).
 *
 * THIS IS SUBJECT TO DISAPPEAR IN A FUTURE CNCL RELEASE !!!!!!!!
 */
#define test_flag(x)	TRUE


#endif /**__CNCL_h**/
