//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Object.h,v 0.31 1996-08-07 17:54:28+02 steppler Exp $
 *
 * CNClass: CNObject --- Base of CNCL inheritance
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Object_h
#define __Object_h

#include <iostream.h>

#include <CNCL/CNCL.h>
#include <CNCL/PObjectID.h>

class CNClass;
class CNParam;
class CNPstream;


/*
 * CNClass description type
 */
typedef const CNClass * CNClassDesc;

/*
 * Type description of class CNObject
 */
extern CNClassDesc CN_OBJECT;



/*
 * Base class CNObject: intrinsic root of CNCL inheritance hierarchy
 */
class CNObject : public CNCL
{
  public:
    // Return class description
    virtual CNClassDesc class_desc() const
    { return CN_OBJECT; }
        
    // Type checking
    virtual bool is_a(CNClassDesc desc) const
    { return desc == CN_OBJECT; }
        
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;

    // Support function for persistent objects,
    // may not be implemented in derived classes
    virtual int store_on(CNPstream &);
    virtual int storer  (CNPstream &);
    virtual CNPID object_id();
    
    // Special error function for XX:cast_from_object()
  protected:
    static CNObject *fatal_type(CNClassDesc from, CNClassDesc to);
};



/*
 * Utility functions to print out objects
 */
ostream &operator << (ostream &strm, const CNObject &obj);
ostream &operator << (ostream &strm, const CNObject *obj);



/*
 * Shortcut
 */
#ifndef CNCAST
#  ifdef NO_TYPE_CHECK
#    define CNCAST(t,x) ((t*)(x))
#  else
#    define CNCAST(t,x) t::cast_from_object(x)
#  endif
#endif


#endif /**__Object_h**/
