// -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_                C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                          N E T W O R K S
 * |_        |_  |_  |_  |_        |_                                C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                      L I B R A R Y
 *
 * $Id: Array3.h,v 1.1 1996-08-06 21:40:52+02 steppler Exp $
 *
 * Class: CNArray3 --- Base class for 3-dimensional arrays
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __Array3_h
#define __Array3_h
 
#include <CNCL/Object.h>                // Base class 
#include <sys/types.h>
 
extern CNClassDesc CN_ARRAY3;    // CNClass Array description

/*
 * The class CNArray3
 */

class CNArray3 : public CNObject
{
  public:       /***** Constructors ******************************************/
    CNArray3()                   : arows(0), acols(0), adepth(0) {}
    CNArray3(CNParam *)          : arows(0), acols(0), adepth(0) {}
    CNArray3(size_t r, size_t c, size_t d) : arows(r), acols(c), adepth(d) {}
 
  public:       /***** Public interface **************************************/
    size_t get_rows()  const { return arows;  }          // Return rows
    size_t get_cols()  const { return acols;  }          // Return cols
    size_t get_depth() const { return adepth; }          // Return depth
    size_t rows()      const { return arows;  }
    size_t cols()      const { return acols;  }
    size_t depth()     const { return adepth; }
 
    virtual void size(size_t r, size_t c, size_t d) = 0; // Resize array
    void set_size(size_t r, size_t c, size_t d) { size(r, c, d); }
 
  private:      /***** Internal private members ******************************/
 
  protected:
    size_t arows, acols, adepth;                          // Rows, columns
    void range_error(int index) const;
    void range_error(int r, int c, int d) const;
 
  public:       /***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const      // CNClass description
    { return CN_ARRAY3; }
            
    virtual bool is_a(CNClassDesc desc) const   // Type checking
    { return desc == CN_ARRAY3 ? TRUE : CNObject::is_a(desc); }
        
    static CNArray3 *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNArray3 *)obj;
#   else
        return (CNArray3 *)( !obj || obj->is_a(CN_ARRAY3)
               ? obj : fatal_type(obj->class_desc(), CN_ARRAY3) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};
 
#endif /**__Array3_h**/

