// -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 *
 * $Id: T_array3.hP,v 1.2 1996-08-07 18:11:25+02 steppler Exp $
 * Class: CNArray3Char  --- 3 dimensional char array class
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Array3Char_h
#define __Array3Char_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Array3.h>
#include <CNCL/Array2Char.h>

extern CNClassDesc CN_ARRAY3CHAR;	// CNClass CNArray3Char description


/*
 * The class CNArray3Char
 */


class CNArray3Char : public CNArray3
{
  public:	/***** Constructors ******************************************/
    CNArray3Char()          : CNArray3(0,0,0), array(NIL), def_val(0) {}
    CNArray3Char(CNParam *) : CNArray3(0,0,0), array(NIL), def_val(0) {}
    CNArray3Char(size_t r, size_t c, size_t d, char def=0);
    CNArray3Char(const CNArray3Char &a);		// Copy constructor

    ~CNArray3Char();

    CNArray3Char &operator = (const CNArray3Char &a);
    
  public:	/***** Public interface **************************************/
    virtual void size(size_t r, size_t c, size_t d);

    void put(int r, int c, int d, char value)// Put value into array
    {
#   ifndef NO_RANGE_CHECK
        if(r<0 || arows<=(size_t)r || 
           c<0 || acols<=(size_t)c || 
           d<0 || adepth<=(size_t)d)
            range_error(r, c, d);
	else
#   endif
	    array[r][c][d] = value;
    }

    char get(int r, int c, int d) const	// Get value from array
    {
#   ifndef NO_RANGE_CHECK
        if(r<0 || arows<=(size_t)r || 
           c<0 || acols<=(size_t)c || 
           d<0 || adepth<=(size_t)d)
	{   range_error(r, c, d); return 0; }
	else
#   endif
	    return array[r][c][d];
    }

    CNArray2Char& operator[] (int index)	// Operator []
    {
#   ifndef NO_RANGE_CHECK
	if (index<0 || arows<=(size_t)index)
	    range_error(index);
#   endif
	return array[index];
    }

  private:	/***** Internal private members ******************************/
    CNArray2Char *array;		// Array of array of array of char
    char def_val;			// Default value
    
    void init(size_t r, size_t c, size_t d);		// Initialize array
    void delete_array();                // Delete array

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_ARRAY3CHAR; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_ARRAY3CHAR ? TRUE : CNArray3::is_a(desc); }
        
    static CNArray3Char *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNArray3Char *)obj;
#   else
	return (CNArray3Char *)( !obj || obj->is_a(CN_ARRAY3CHAR)
	       ? obj : fatal_type(obj->class_desc(), CN_ARRAY3CHAR) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNArray3Char(param) : new CNArray3Char; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__Array3Char_h**/
