//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLIterator.h,v 0.34 1996-08-07 17:54:58+02 steppler Exp $
 *
 * Class: CNDLIterator ---  Double linked list iterator
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNDLIterator_h
#define __CNDLIterator_h


#include <CNCL/SLIterator.h>		// Base class
#include <CNCL/DLList.h>

extern CNClassDesc CN_DLITERATOR;	// Class CNDLIterator description


/*
 * The class CNDLIterator
 */

class CNDLIterator : public CNSLIterator
{
  public:	/***** Constructors ******************************************/
    CNDLIterator()          : CNSLIterator() {}
    CNDLIterator(CNParam *) : CNSLIterator() {}
    CNDLIterator(const CNDLList *new_list) : CNSLIterator(new_list)  {}
    CNDLIterator(const CNDLList &new_list) : CNSLIterator(&new_list) {}
 
  public:	/***** Public interface **************************************/
    CNObject *last_object();
    CNObject *last();
    CNObject *prev_object();
    CNObject *prev();
    CNObject *operator--();		// Prefix --arg
    CNObject *operator--(int);		// Postfix arg-- (C++ 3.0)

    // Get position 
    virtual CNDLObject *position();
    virtual CNDLObject *get_position();

    // Set position
    virtual void position(CNDLObject *pos);
    virtual void set_position(CNDLObject *pos);

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_DLITERATOR; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_DLITERATOR ? TRUE : CNSLIterator::is_a(desc); }
        
    static CNDLIterator *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDLIterator *)obj;
#   else
	return (CNDLIterator *)( !obj || obj->is_a(CN_DLITERATOR)
	       ? obj : fatal_type(obj->class_desc(), CN_DLITERATOR) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDLIterator(param) : new CNDLIterator; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNDLIterator &obj);
ostream &operator << (ostream &strm, const CNDLIterator *obj);

#endif /**__CNDLIterator_h**/
