//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLList.h,v 0.34 1996-08-07 17:55:00+02 steppler Exp $
 *
 * Class: CNDLList --- Double linked list
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNDLList_h
#define __CNDLList_h


#include "SLList.h"		// Base class
#include "DLObject.h"

extern CNClassDesc CN_DLLIST;	// Class CNDLList description


/*
 * The class CNDLList
 */

class CNDLList : public CNSLList
{
  public:	/***** Constructors ******************************************/
    CNDLList();
    CNDLList(CNParam *p);
    CNDLList(const CNDLList &);
    virtual ~CNDLList();
    
  public:	/***** Public interface **************************************/
    
    // Traverse list
    virtual CNDLObject *first() const;
    virtual CNDLObject *next(CNDLObject *link) const;
    virtual CNDLObject *last() const;
    virtual CNDLObject *prev(CNDLObject *link) const;
    
    // Add items
    virtual CNDLObject *append(CNObject *obj);
    virtual CNDLObject *append(CNObject &obj);
    virtual CNDLObject *prepend(CNDLObject *obj);
    virtual CNDLObject *prepend(CNObject *obj);
    virtual CNDLObject *prepend(CNObject &obj);
    virtual CNDLObject *append(CNDLObject *obj);
    
    // Delete items
    virtual CNDLObject *remove_object(CNDLObject *pos);
    virtual CNDLObject *delete_object(CNDLObject *pos);
    
    // Insert items
    virtual CNDLObject *insert_before(CNDLObject *pos, CNObject *obj);
    virtual CNDLObject *insert_before(CNDLObject *pos, CNObject &obj);
    virtual CNDLObject *insert_before(CNDLObject *pos, CNDLObject *obj);
    virtual CNDLObject *insert_after (CNDLObject *pos, CNObject *obj);
    virtual CNDLObject *insert_after (CNDLObject *pos, CNObject &obj);
    virtual CNDLObject *insert_after (CNDLObject *pos, CNDLObject *obj);

    // Check list
    bool ok();

  private:	/***** Internal private members ******************************/

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_DLLIST; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_DLLIST ? TRUE : CNSLList::is_a(desc); }
        
    static CNDLList *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDLList *)obj;
#   else
	return (CNDLList *)( !obj || obj->is_a(CN_DLLIST)
	       ? obj : fatal_type(obj->class_desc(), CN_DLLIST) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL);
    
    
// Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


ostream &operator << (ostream &strm, const CNDLList &obj);
ostream &operator << (ostream &strm, const CNDLList *obj);

#endif /**__CNDLList_h**/
