//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLObject.c,v 0.32 1996-08-07 17:55:02+02 steppler Exp $
 *
 * Class: CNDLObject --- Double linked object for CNDLList
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 *****************************************************************************/

#include <CNCL/Class.h>

#include "DLObject.h"
CNDLObject::CNDLObject() : CNSLObject(), pprev(NIL) {}
CNDLObject::CNDLObject(CNParam *p) : CNSLObject(p), pprev(NIL){}
CNDLObject::CNDLObject(CNObject *obj) : CNSLObject(obj), pprev(NIL){}
CNDLObject::CNDLObject(const CNDLObject &) : CNSLObject(), pprev(NIL)
{
    fatal(NIL, "can't copy CNDLObject object");
}

// Set/get next pointer
CNDLObject* CNDLObject::next(CNDLObject *p)
{
    pnext = p;
    return (CNDLObject *)pnext;
}
CNDLObject* CNDLObject::next()
{
    return (CNDLObject *)pnext;
}
CNDLObject* CNDLObject::set_next(CNDLObject *p)
{
    pnext = p;
    return (CNDLObject *)pnext;
}
CNDLObject* CNDLObject::get_next()
{
    return (CNDLObject *)pnext;
}

// Set/get prev pointer
CNDLObject *CNDLObject::prev(CNDLObject *p)
{
    pprev = p; return pprev;
}
CNDLObject *CNDLObject::prev()
{
    return pprev;
}
CNDLObject *CNDLObject::set_prev(CNDLObject *p)
{
    pprev = p; return pprev;
}
CNDLObject *CNDLObject::get_prev()
{
    return pprev;
}


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNDLObject::print(ostream &strm) const
{
    strm <<  "this=" << hex << (unsigned long)this
	 << " next=" << hex << (unsigned long)pnext
	 << " prev=" << hex << (unsigned long)pprev << dec << endl
	 <<  "obj="  << pobj;

}

// Debug output
void CNDLObject::dump(ostream &strm) const
{
    strm << "CNDLObject { $Revision: 0.32 $ ..." << " }" << endl
	 <<  "this=" << hex << (unsigned long)this
	 << " next=" << hex << (unsigned long)pnext
	 << " prev=" << hex << (unsigned long)pprev
	 << " obj="  << hex << (unsigned long)pobj << dec << endl;
    if(pobj)
	pobj->dump(strm);
    strm << "}" << endl;

}

// IOStream operator <<
ostream &operator << (ostream &strm, const CNDLObject &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNDLObject *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNDLObject
static CNClass CNDLObject_desc("CNDLObject", "$Revision: 0.32 $",
			    CNDLObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_DLOBJECT = &CNDLObject_desc;
