//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLObject.h,v 0.32 1996-08-07 17:55:03+02 steppler Exp $
 *
 * Class: CNDLObject ---Double linked object for CNDLList
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNDLObject_h
#define __CNDLObject_h


#include "SLObject.h"		// Base class


extern CNClassDesc CN_DLOBJECT;	// Class CNDLObject description

class CNDLList;
class CNDLIterator;


/*
 * The class CNDLObject
 */

class CNDLObject : public CNSLObject
{
    friend class CNDLList;
    friend class CNDLIterator;

  public:	/***** Constructors ******************************************/
    CNDLObject();
    CNDLObject(CNParam *);
    CNDLObject(CNObject *obj);
  private:
    CNDLObject(const CNDLObject &);

  protected:
    // Only CNDLList and heirs of CNDLObject may delete CNDLObject's
    virtual ~CNDLObject() {}
 

  public:	/***** Public interface **************************************/

    // Set/get next pointer
    virtual CNDLObject *next(CNDLObject *p);
    virtual CNDLObject *next();
    virtual CNDLObject *set_next(CNDLObject *p);
    virtual CNDLObject *get_next();

    // Set/get prev pointer
    virtual CNDLObject *prev(CNDLObject *p);
    virtual CNDLObject *prev();
    virtual CNDLObject *set_prev(CNDLObject *p);
    virtual CNDLObject *get_prev();
    
  private:	/***** Internal private members ******************************/

    CNDLObject *pprev;


  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_DLOBJECT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_DLOBJECT ? TRUE : CNSLObject::is_a(desc); }
        
    static CNDLObject *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDLObject *)obj;
#   else
	return (CNDLObject *)( !obj || obj->is_a(CN_DLOBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_DLOBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDLObject(param) : new CNDLObject; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNDLObject &obj);
ostream &operator << (ostream &strm, const CNDLObject *obj);

#endif /**__CNDLObject_h**/
