//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: HashIterator.c,v 0.30 1996-08-07 17:55:07+02 steppler Exp $
 *
 * Class: CNHashIterator --- hash table sequential iterator
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include <CNCL/Class.h>

#include "HashIterator.h"

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNHashIterator::print(ostream &strm) const
{
    strm << "hash_table = " << hash_table << " index = " << index << endl;
}

// Debug output
void CNHashIterator::dump(ostream &strm) const
{
    strm << "CNHashIterator { $Revision: 0.30 $ "
	 << "hash_table = ";
    if (hash_table)
    {
    	strm << endl;
	hash_table->dump(strm);
    }
    else
        strm << "(NIL)" << endl;
    strm << "index = "
	 << index
	 << " }" << endl;
}

// IOStream operator <<
ostream &operator << (ostream &strm, const CNHashIterator &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNHashIterator *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNHashIterator
static CNClass CNHashIterator_desc("CNHashIterator", "$Revision: 0.30 $",
			    CNHashIterator::new_object);

// "Type" for type checking functions
CNClassDesc CN_HASHITERATOR = &CNHashIterator_desc;
