//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Key.h,v 0.30 1996-08-07 17:55:18+02 steppler Exp $
 *
 * CNClass: CNKey --- Abstract base class for object management via keys
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Key_h
#define __Key_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_KEY;	// CNClass CNKey description

/*
 * The class CNKey
 */

class CNKey : public CNObject
{
    CNObject *object;
    
public:
    void set_object(CNObject &obj)
    {
	object = &obj;
    }
    void set_object(CNObject *obj) 
    {
	object = obj;
    }
    CNObject *get_object() const 
    {
	return object;
    }
    
    virtual unsigned long hash(unsigned long capacity, int par = 0) const = 0;
    virtual bool compare(const CNKey *k) const = 0;
    virtual bool compare(const CNKey &k) const = 0;
            
    /***** Constructors ******************************************************/
public:
    CNKey(CNObject *obj = NIL) : object(obj) {}
    CNKey(CNParam *)      : object(NIL) {}
    
    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_KEY;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_KEY ? TRUE : CNObject::is_a(desc);
    };
        
    static CNKey *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNKey *)obj;
#   else
	return (CNKey *)( !obj || obj->is_a(CN_KEY)
	       ? obj : fatal_type(obj->class_desc(), CN_KEY) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};

#endif /**__Key_h**/
