//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: PrioQueueFIFO.c,v 0.31 1996-08-07 17:55:27+02 steppler Exp $
 *
 * Class: CNPrioQueueFIFO --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 *****************************************************************************/

#include "PrioQueueFIFO.h"



CNPrioQueueFIFO::CNPrioQueueFIFO()
{
    queues = new CNQueueFIFO* [prio = 2];
    for (int i=0; i<prio; i++) queues[i] = new CNQueueFIFO;
    n=0;
}
 

   
CNPrioQueueFIFO::CNPrioQueueFIFO(int prios)
{
    queues = new CNQueueFIFO* [prio = prios];
    for (int i=0; i<prio; i++) queues[i] = new CNQueueFIFO;
    n=0;
}
 



int CNPrioQueueFIFO::priorities()
{
    return prio;
}



bool CNPrioQueueFIFO::empty() const
{
    return n == 0;
}



bool CNPrioQueueFIFO::full() const
{
    return FALSE;
}



int CNPrioQueueFIFO::length() const
{
    return n;
}



void CNPrioQueueFIFO::put(CNObject *obj)
{
    if (!obj->is_a(CN_JOB))
        fatal("CNPrioQueueFIFO::put", 
              " only CNJobs are accepted in this queue-type");
 
    CNJob *job = CNJob::cast_from_object(obj);
    int p = job->priority;

    if (p >= prio || p < 0)
	fatal("CNPrioQueueFIFO::put", " wrong priority");

    queues[p]->put( job );
    n++;
}



CNObject *CNPrioQueueFIFO::get()
{
    CNObject *obj = NIL;

    for(int i=0; i<prio; i++)
	if (!queues[i]->empty())
	{
	    obj = queues[i]->get();
	    n--;
	    break;
	}

    return obj;
}

CNObject *CNPrioQueueFIFO::peek()
{
    for(int i = 0; i < prio; i++)
	if (!queues[i]->empty())
	    return queues[i]->peek();

    return NIL;
}

void CNPrioQueueFIFO::delete_all()
{
    for (int i=0; i<prio; i++) queues[i]->delete_all();
    n = 0;
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNPrioQueueFIFO::print(ostream &strm) const
{
    strm << "length=" << n << " priorities=" << prio << endl;
}

// Debug output
void CNPrioQueueFIFO::dump(ostream &strm) const
{
    strm << "CNPrioQueueFIFO { $Revision: 0.31 $ ..." << endl
	 << "length=" << n << " priorities=" << prio << endl;
    for (int i=0; i<prio; i++) queues[i]->dump(strm);
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNPrioQueueFIFO
static CNClass CNPrioQueueFIFO_desc("CNPrioQueueFIFO", "$Revision: 0.31 $",
			    CNPrioQueueFIFO::new_object);

// "Type" for type checking functions
CNClassDesc CN_PRIOQUEUEFIFO = &CNPrioQueueFIFO_desc;
