//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: QueueRandom.h,v 0.31 1996-08-07 17:55:39+02 steppler Exp $
 *
 * Class: CNQueueRandom --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNQueueRandom_h
#define __CNQueueRandom_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Queue.h>		// Base class

#include <CNCL/DLList.h>
#include <CNCL/RndInt.h>
#include <CNCL/FiboG.h>

extern CNClassDesc CN_QUEUERANDOM;	// Class CNQueueRandom description


/*
 * The class CNQueueRandom
 */

class CNQueueRandom : public CNQueue
{
  public:	/***** Constructors ******************************************/
    CNQueueRandom(); 				// Default constructor
    CNQueueRandom(CNParam *) {}			// CNParam constructor
    CNQueueRandom(CNRNG* rng):n(0),internal_rng(FALSE) { rand.generator(rng); }
    ~CNQueueRandom();
    
  public:	/***** Public interface **************************************/
    virtual bool empty()  const;	// Is queue empty?
    virtual bool full()   const;	// Is queue full?
    virtual int  length() const;	// Length of queue
    virtual void put(CNObject *obj);	// Put object into queue
    virtual CNObject *get();		// Get object from queue
    virtual CNObject *peek();		// Get object from queue
                                        // without removing it
    virtual void delete_all();		// Delete all objects in queue
 
  private:	/***** Internal private members ******************************/
    int n;
    CNDLList list;
    CNRndInt rand;
    CNRNG *rng;
    bool internal_rng;
        
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_QUEUERANDOM; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_QUEUERANDOM ? TRUE : CNQueue::is_a(desc); }
        
    static CNQueueRandom *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNQueueRandom *)obj;
#   else
	return (CNQueueRandom *)( !obj || obj->is_a(CN_QUEUERANDOM)
	       ? obj : fatal_type(obj->class_desc(), CN_QUEUERANDOM) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNQueueRandom(param) : new CNQueueRandom; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNQueueRandom_h**/
