//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SLIterator.c,v 1.4 1996-08-07 17:55:42+02 steppler Exp $
 *
 * Class: CNSLIterator --- Single linked list iterator
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 *****************************************************************************/

#include <CNCL/Class.h>

#include "SLIterator.h"

CNSLIterator::CNSLIterator() : list(NIL), pnt(NIL) 	// Default constructor
{}

CNSLIterator::CNSLIterator(const CNSLList *new_list)
{
    reset(new_list);
}

CNSLIterator::CNSLIterator(const CNSLList &new_list)
{
    reset(&new_list);
}

CNSLIterator::CNSLIterator(CNParam *) : list(NIL), pnt(NIL)
{}


// Reset iterator
void CNSLIterator::reset(const CNSLList *new_list)
{
    list = new_list;
    reset();
}
void CNSLIterator::reset(const CNSLList &new_list)
{
    list = &new_list;
    reset();
}
void CNSLIterator::reset()
{
    pnt = list ? list->first() : NIL;
}

// Get object from actual list position
CNObject *CNSLIterator::get_object()
{
    return pnt ? pnt->get_object() : NIL;
}
CNObject *CNSLIterator::object()
{
    return pnt ? pnt->get_object() : NIL;
}

// Get position (CNDLObject *) in CNDLList
CNSLObject *CNSLIterator::position()
{
    return pnt;
}
CNSLObject *CNSLIterator::get_position()
{
    return pnt;
}

void CNSLIterator::position(CNSLObject *pos)
{
    CNSLObject* p;
    
    if (!list)
	fatal("Iterator not initialized with a linked list");
    for (p = list->first(); p; p = p->next())
	if (pos == p)
	{
	    pnt = pos;
	    return;
	}
    fatal("Node not in List");
}

void CNSLIterator::set_position(CNSLObject *pos)
{
    position(pos);
}

// Move pointer to first object, retrieve current object
CNObject *CNSLIterator::first_object()
{
    pnt = list ? list->first() : NIL;
    return pnt ? pnt->object() : NIL;
}
CNObject *CNSLIterator::first()
{
    pnt = list ? list->first() : NIL;
    return pnt ? pnt->object() : NIL;
}

// Move pointer to last object, retrieve current object
CNObject *CNSLIterator::last_object()
{
    pnt = list ? list->last() : NIL;
    return pnt ? pnt->object() : NIL;
}
CNObject *CNSLIterator::last()
{
    pnt = list ? list->last() : NIL;
    return pnt ? pnt->object() : NIL;
}

// Advance pointer to next object, retrieve current object
CNObject *CNSLIterator::next_object()
{
    CNSLObject *p;
    p = pnt;
    if(pnt)
	pnt = pnt->next();
    return p ? p->object() : NIL;
}
CNObject *CNSLIterator::next()
{
    return next_object();
}
CNObject *CNSLIterator::operator++()	// Prefix ++arg
{
    return next_object();
}
CNObject *CNSLIterator::operator++(int)	// Postfix arg++ (C++ 3.0)
{
    return next_object();
}

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSLIterator::print(ostream &strm) const
{
     strm << "list=" << list << " pnt=" << pnt << endl;
}

// Debug output
void CNSLIterator::dump(ostream &strm) const
{
    strm << "CNSLIterator { $Revision: 1.4 $ ..."<< endl
	 << "list=";
    if(list)
    {
    	strm << endl;
	list->dump(strm);
    }
    else
        strm << "(NIL)" << endl;
    strm << "pnt=";
    if(pnt)
    {
    	strm << endl;
	pnt->dump(strm);
    }
    else
        strm << "(NIL)" << endl;
    strm << " }" << endl;
}

// IOStream operator <<
ostream &operator << (ostream &strm, const CNSLIterator &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNSLIterator *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSLIterator
static CNClass CNSLIterator_desc("CNSLIterator", "$Revision: 1.4 $",
			    CNSLIterator::new_object);

// "Type" for type checking functions
CNClassDesc CN_SLITERATOR = &CNSLIterator_desc;
