//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SLList.h,v 1.5 1996-08-07 17:55:46+02 steppler Exp $
 *
 * Class: CNSLList --- Single Linked List
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNSLList_h
#define __CNSLList_h

#include "SLObject.h"
#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_SLLIST;	// Class CNSLList description


/*
 * The class CNSLList
 */

class CNSLList : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNSLList();
    CNSLList(CNParam *);
    CNSLList(const CNSLList &);
    virtual ~CNSLList();
    
  public:	/***** Public interface **************************************/
    // Traverse list
    virtual CNSLObject *first() const;
    virtual CNSLObject *next(CNSLObject *link) const;
    virtual CNSLObject *last() const;
    virtual CNSLObject *prev(CNSLObject *link) const;
    
    // Check for empty list
    bool empty() const;
        
    // Return # of items in list
    unsigned long length() const;
        
    // Add items
    virtual CNSLObject *prepend(CNObject *obj);
    virtual CNSLObject *prepend(CNObject &obj);
    virtual CNSLObject *prepend(CNSLObject *obj);
    virtual CNSLObject *append(CNObject *obj);
    virtual CNSLObject *append(CNObject &obj);
    virtual CNSLObject *append(CNSLObject *obj);
    
    // Delete items
    virtual CNSLObject *remove_object(CNSLObject *pos);
    virtual CNSLObject *delete_object(CNSLObject *pos);
    virtual void delete_all();
    virtual void delete_all_w_obj();
    
    // Insert items
    virtual CNSLObject *insert_before(CNSLObject *pos, CNObject *obj);
    virtual CNSLObject *insert_before(CNSLObject *pos, CNObject &obj);
    virtual CNSLObject *insert_before(CNSLObject *pos, CNSLObject *obj);
    virtual CNSLObject *insert_after (CNSLObject *pos, CNObject *obj);
    virtual CNSLObject *insert_after (CNSLObject *pos, CNObject &obj);
    virtual CNSLObject *insert_after (CNSLObject *pos, CNSLObject *obj);


  protected:	/***** Internal private members ******************************/
    CNSLObject *pfirst;			// Pointer to first CNSLObject of list
    CNSLObject *plast;			// Pointer to last  CNSLObject of list
    unsigned long count;		// # of items in list

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_SLLIST; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_SLLIST ? TRUE : CNObject::is_a(desc); }
        
    static CNSLList *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNSLList *)obj;
#   else
	return (CNSLList *)( !obj || obj->is_a(CN_SLLIST)
	       ? obj : fatal_type(obj->class_desc(), CN_SLLIST) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNSLList(param) : new CNSLList; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNSLList &obj);
ostream &operator << (ostream &strm, const CNSLList *obj);

#endif /**__CNSLList_h**/
