//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SLObject.c,v 1.2 1996-08-07 17:55:47+02 steppler Exp $
 *
 * Class: CNSLObject --- Single linked object for CNSLList
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 *****************************************************************************/

#include <CNCL/Class.h>

#include "SLObject.h"

CNSLObject::CNSLObject() : pnext(NIL), pobj(NIL)
{}

CNSLObject::CNSLObject(CNParam *) : pnext(NIL), pobj(NIL)
{}

CNSLObject::CNSLObject(CNObject *obj) : pnext(NIL), pobj(obj)
{}

CNSLObject::CNSLObject(const CNSLObject &) : pnext(NIL),  pobj(NIL)
{
    fatal(NIL, "can't copy CNSLObject object");
}

// Set/get next pointer

CNSLObject* CNSLObject::next(CNSLObject *p)
{
    pnext = p; return pnext;
}
CNSLObject* CNSLObject::next()
{
    return pnext;
}
CNSLObject* CNSLObject::set_next(CNSLObject *p)
{
    pnext = p; return pnext;
}
CNSLObject* CNSLObject::get_next()
{
    return pnext;
}

// Set/get object pointer

CNObject* CNSLObject::object(CNObject *o)
{
    pobj = o; return pobj;
}
CNObject* CNSLObject::object()
{
    return pobj;
}
CNObject* CNSLObject::set_object(CNObject *o)
{
    pobj = o; return pobj;
}
CNObject* CNSLObject::get_object()
{
    return pobj;
}

// Delete object

void CNSLObject::delete_object()
{
    delete pobj;
}


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSLObject::print(ostream &strm) const
{
    strm <<  "this=" << hex << (unsigned long)this
	 << " next=" << hex << (unsigned long)pnext
	 <<  "obj="  << pobj;
}

// Debug output
void CNSLObject::dump(ostream &strm) const
{
    strm << "CNDLObject { "
	 << "$Revision: 1.2 $" << endl
	 <<  "this=" << hex << (unsigned long)this
	 << " next=" << hex << (unsigned long)pnext
	 << " obj="  << hex << (unsigned long)pobj << dec << endl;
    if(pobj)
	pobj->dump(strm);
    strm << "}" << endl;

}

// IOStream operator <<
ostream &operator << (ostream &strm, const CNSLObject &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNSLObject *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSLObject
static CNClass CNSLObject_desc("CNSLObject", "$Revision: 1.2 $",
			    CNSLObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_SLOBJECT = &CNSLObject_desc;
