//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Stack.h,v 0.31 1996-08-07 17:55:54+02 steppler Exp $
 *
 * Class: CNStack --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNStack_h
#define __CNStack_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/QueueLIFO.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_STACK;	// Class CNStack description


/*
 * The class CNStack
 */

class CNStack : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNStack():s_size(0),s_depth(0) {}		// Default constructor
    CNStack(CNParam *) {}			// CNParam constructor
    CNStack(long elem):s_size(elem),s_depth(0) {};

  public:	/***** Public interface **************************************/
    void push(CNObject*);
    CNObject *pull();
    CNObject *pop()
    { return pull(); }
    long depth()		//elements on stack
    { return s_depth; }
    bool empty()
    { return depth()==0; }

    long size()			//max. elements on stack
    { return s_size; }

    void size(long);  	//resize stack
    
    void clear();
    
  private:	/***** Internal private members ******************************/
    CNQueueLIFO queue;
    long s_size;
    long s_depth;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_STACK; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_STACK ? TRUE : CNObject::is_a(desc); }
        
    static CNStack *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNStack *)obj;
#   else
	return (CNStack *)( !obj || obj->is_a(CN_STACK)
	       ? obj : fatal_type(obj->class_desc(), CN_STACK) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNStack(param) : new CNStack; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNStack_h**/
