//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: IntAVLTree.h,v 1.2 1996-08-07 17:56:09+02 steppler Exp $
 *
 * Class: IntAVLTree --- example using CNAVLTree
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __IntAVLTree_h
#define __IntAVLTree_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/AVLTree.h>		// Base class

extern CNClassDesc CN_INTAVLTREE;	// Class IntAVLTree description


/*
 * The class IntAVLTree
 */

class IntAVLTree : public CNAVLTree
{

    friend class IntAVLNode;

  public:	/***** Constructors ******************************************/
    IntAVLTree() {}				// Default constructor
    IntAVLTree(CNParam *param) {}			// CNParam constructor

  public:	/***** Public interface **************************************/

    virtual CNAVLNode *find(long key);
    virtual CNAVLNode *remove(long key);

  private:	/***** Internal private members ******************************/

    long searchkey;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_INTAVLTREE; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_INTAVLTREE ? TRUE : CNAVLTree::is_a(desc); }
        
    static IntAVLTree *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (IntAVLTree *)obj;
#   else
	return (IntAVLTree *)( !obj || obj->is_a(CN_INTAVLTREE)
	       ? obj : fatal_type(obj->class_desc(), CN_INTAVLTREE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new IntAVLTree(param) : new IntAVLTree; }
};

#endif /**__IntAVLTree_h**/
