// -*- C++ -*-

#include <iostream.h>

#include <CNCL/DLList.h>
#include <CNCL/DLIterator.h>

#include "Test.h"



int main()
{
    CNDLList list;
    CNDLObject *pos1, *pos2, *pos3;
    Test* t;
    
    list.append(new Test(111));
    list.append(new Test(222));
    list.append(new Test(333));
    list.append(new Test(444));
    list.append(new Test(555));
    list.append(new Test(666));
    list.append(new Test(777));
    list.append(new Test(888));
    list.append(new Test(999));

//    cout << list;

    CNDLIterator trav(list);
    CNObject *p;

    // Output original list
    cout << "----- Output original list -----" << endl;
    while( (p = trav++) )
	cout << *p;

    // Set position
    cout << "----- Set posiiton -----" << endl;

    for (trav.reset(); trav.object(); trav++)
    {
	t = Test::cast_from_object(trav.object());
	if (t->get_n() == 111)
	    pos1 = trav.get_position();
	else if (t->get_n() == 555)
	    pos2 = trav.get_position();
	else if (t->get_n() == 999)
	    pos3 = trav.get_position();
    }

    trav.set_position(pos2);
    cout << trav.object();
    trav.position(pos1);
    cout << trav.object();
    trav.position(pos3);
    cout << trav.object();
    
    // Add items before and after each element
    for(trav.reset(list); (p=trav.object());)
    {
	CNDLObject *pos;
	pos = trav.position();
	trav++;
	trav++;
	list.insert_before(pos, new Test(0));
	list.insert_after (pos, new Test(1));
    }
    
    cout << "----- Add items before and after -----" << endl;
    for(trav.reset(list); (p=trav.object()); trav++)
    {
	cout << *p;
    }

    // Delete all items with n == 0
    cout << "----- Delete all items with n == 0 -----" << endl;
    for(trav.reset(list); (p=trav.object()); )
    {
	Test *t;
	CNDLObject *pos;

	pos = trav.position();
	trav++;

	t = Test::cast_from_object(p);
	if(t->get_n() == 0)
	{
	    list.delete_object(pos);
	    delete p;
	}
    }

    for(trav.reset(list); (p=trav.object()); trav++)
    {
	cout << *p;
    }

    // Delete all items with n == 1
    cout << "----- Delete all items with n == 1 -----" << endl;
    for(trav.reset(list); (p=trav.object()); )
    {
	Test *t;
	CNDLObject *pos;

	pos = trav.position();
	trav++;

	t = Test::cast_from_object(p);
	if(t->get_n() == 1)
	{
	    list.delete_object(pos);
	    delete p;
	}
    }

    for(trav.first(); (p=trav.object()); trav++)
    {
	cout << *p;
    }

    // Reverse output
    cout << "----- Reverse output -----" << endl;
    for(trav.last(); (p=trav.object()); trav--)
    {
	cout << *p;
    }

    // Delete all items
    list.delete_all();
    cout << "----- Delete all items -----" << endl;
    for(trav.reset(list); (p=trav.object()); trav++)
    {
	cout << *p;
    }
    
    list.ok();
//    list.dump();
}







