//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventBaseSched.c,v 0.30 1996-08-07 17:56:22+02 steppler Exp $
 *
 * Class: CNEventBaseSched --- Abstract scheduler base class
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include <CNCL/Class.h>

#include "EventBaseSched.h"



/*
 * Delete events from/to one EventHandler
 */
void CNEventBaseSched::delete_events_from(CNEventHandler *h)
{
    delete_events(h, FALSE);
}

void CNEventBaseSched::delete_events_to(CNEventHandler *h)
{
    delete_events(h, TRUE);
}



/*
 * Start scheduler
 */
void CNEventBaseSched::start(CNEvent *ev)
{
    add_event(ev);
    process_events();
}


void CNEventBaseSched::start()
{
    process_events();
}



/*
 * Event processing loop
 */
void CNEventBaseSched::process_events()
{
    CNEvent *ev;
    CNEventHandler *handler;

    stop_flag = FALSE;
    
    // Process events from list
    while( (ev = next_event()) )
    {
	simtime = ev->scheduled();
	handler = ev->to();
	handler->process_event(this, simtime, ev);
	delete ev;

	// Stop event processing, if flag set. Events stay in list.
	if(stop_flag)
	    break;
    }
}



/*
 * Event processing loop, all events scheduled time == now
 */
void CNEventBaseSched::process_now()
{
    CNEvent *ev;
    CNEventHandler *handler;
    
    stop_flag = FALSE;
    
    while( (ev = peek_event()) )
    {
        if(ev->scheduled() > simtime)
            break;
        
        ev = next_event();
        handler = ev->to();
        handler->process_event(this, simtime, ev);
        delete ev;

        // Stop event processing, if flag set. Events stay in list.
        if(stop_flag)
            break;
    }
}  



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNEventBaseSched
static CNClass CNEventBaseSched_desc("CNEventBaseSched",
				     "$Revision: 0.30 $", NIL);

// "Type" for type checking functions
CNClassDesc CN_EVENTBASESCHED = &CNEventBaseSched_desc;
