//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventHeapSched.h,v 0.30 1996-08-07 17:56:36+02 steppler Exp $
 *
 * CNClass: CNEventHeapSched --- CNEvent scheduler
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __EventHeapSched_h
#define __EventHeapSched_h

#include <CNCL/Object.h>
#include <CNCL/Event.h>
#include <CNCL/EventHandler.h>
#include <CNCL/EventBaseSched.h>
#include <CNCL/EventHIterator.h> 
 
extern CNClassDesc CN_EVENTHEAPSCHED;



/*
 * The class CNEventHeapSched
 */

class CNEventHeapSched : public CNEventBaseSched
{
    friend class CNEventHIterator;
    
public:
    void add_event(CNEvent *ev);		// Send event (add to list)
    void send_event(CNEvent *ev) { add_event(ev); };
    void delete_event(CNEventID id);	// Delete event from list
    void delete_events(CNEventHandler *evh, bool to=TRUE);
                                        // Delete events for/from EvH
    CNEvent *peek_event();		// Peek at next event
    CNEvent *peek_event(CNEventID id);	// Peek at event with id
    CNEvent *next_event();
    
    void stop();			// Stop scheduler

    CNEventIterator *create_iterator();	// create event iterator 
    
    // Private members
private:
    CNEvent** heap;                     // Heap
    long heap_l;                        // Heap: allocated size
    long heap_n;                        // Heap: current size

    void heap_upheap(long k);           // Heap: upheap()
    void heap_downheap(long k);         // Heap: downheap()
    CNEvent *heap_remove();             // Heap: remove() (get next Event)
    
    /***** Constructors ******************************************************/
public:
    CNEventHeapSched();
    CNEventHeapSched(CNParam *param);
    ~CNEventHeapSched();
    
  private:
    CNEventHeapSched(const CNEventHeapSched &)
    {
	fatal(NIL, "can't copy CNEventHeapSched object");
    }

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EVENTHEAPSCHED;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EVENTHEAPSCHED ? TRUE : CNEventBaseSched::is_a(desc);
    };
        
    static CNEventHeapSched *cast_from_object(CNObject *obj) 
    {
#   ifdef NO_TYPE_CHECK
	return (CNEventHeapSched *)obj;
#   else
	return (CNEventHeapSched *)
	    ( !obj || obj->is_a(CN_EVENTHEAPSCHED)
	      ? obj : fatal_type(obj->class_desc(), CN_EVENTHEAPSCHED) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ?
	  new CNEventHeapSched(param) : new CNEventHeapSched; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__EventHeapSched_h**/
