//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventIterator.h,v 0.30 1996-08-07 17:56:39+02 steppler Exp $
 *
 * Class: CNEventIterator --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNEventIterator_h
#define __CNEventIterator_h


#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_EVENTITERATOR;	// Class CNEventIterator description

class CNEvent;

/*
 * The class CNEventIterator
 */

class CNEventIterator : public CNObject
{
  protected:    /***** Constructors ******************************************/
    CNEventIterator() {}				// Default constructor

  public:	/***** Public interface **************************************/
    virtual CNEvent *next_event() = 0;           // returns an event
    virtual void delete_current_event() = 0;     // deletes last returned event
    
  private:	/***** Internal private members ******************************/

  protected:
    CNEvent *act_event;		// currently used event 
    bool use_current;           // flag
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EVENTITERATOR; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EVENTITERATOR ? TRUE : CNObject::is_a(desc); }
        
    static CNEventIterator *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNEventIterator *)obj;
#   else
	return (CNEventIterator *)( !obj || obj->is_a(CN_EVENTITERATOR)
	       ? obj : fatal_type(obj->class_desc(), CN_EVENTITERATOR) );
#   endif
    }
};

#endif /**__CNEventIterator_h**/
