// -*- C++ -*-


#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>

#include <CNCL/FiboG.h>
#include <CNCL/NegExp.h>
#include <CNCL/LREF.h>

/* Uncomment for old scheduler */
/* #define NO_HEAP_SCHEDULER */
#include <CNCL/sim.h>

extern "C" long clock();


// Verlustsystem M/M/n

enum { EV_in, EV_out };

class Generator: public CNEventHandler
{
  public:
    Generator(CNEventHandler *handler, CNRNG *rng, long jobs);
    virtual void event_handler(const CNEvent *ev); 
  private:
    CNNegExp &rnd;
    long todo;
    CNEventHandler *eh;
};

Generator::Generator(CNEventHandler *handler, CNRNG *rng, long jobs) 
  : rnd(*new CNNegExp(1.0,rng)), todo(jobs), eh(handler) {};

void Generator::event_handler(const CNEvent *ev) {
    if(ev->type() != EV_in)
	error("mm1: ", "illegal event in generator");

    send_now( new CNEvent(EV_in,eh) );
    if (--todo > 0) {
	send_delay( new CNEvent(EV_in,this), rnd() );
    };
};

class Server : public CNEventHandler 
{
  public:
    virtual void event_handler(const CNEvent *ev); 
    Server(CNRNG *rng, long n, double r);
    ~Server();
  private:
    CNNegExp &rnd;
    long n,busy;
    double r;
    double stat_r, stat_l;
    long stat_cnt;
};

Server::Server(CNRNG *rng, long nn, double nr)
  : rnd(*new CNNegExp(1.0,rng)), n(nn), r(nr) {
    busy = 0;
    stat_r = 0;
    stat_l = 0;
    stat_cnt = 0;
};

Server::~Server() {
    cout <<"# r_th: "<< r
	 <<"  r: "<< stat_r / stat_cnt 
	 << "  l: "<< stat_l / stat_cnt << endl;
}

void Server::event_handler(const CNEvent *ev) {
    switch (ev->type()) {
      case EV_in:
	stat_cnt++;
	stat_r += (double)busy  / (double)n;
	if (busy < n) {
	    busy++;
	    send_delay(new CNEvent(EV_out, this), rnd() * r * n);
	} else {
	    stat_l += 1.0;
	};
	break;
      case EV_out:
	if (busy > 0) busy--;
	break;
      default:
	error("MMn: ", "illegal event");
	break;
    };
};


main(int argc, char**argv) 
{
    if (argc<3) {
	cout <<"usage: mmn n jobs"<< endl;
	exit(0);
    };
    long n = atol(argv[1]);
    long j = atol(argv[2]);

    CNEvent::set_max_events(n*3+5);

    cout <<"#   running MM"<< n <<" with "<< j <<" jobs"<< endl;
    
    CNFiboG rng;
//    Server s1( &rng, n, 0.5);
//    Server s2( &rng, n, 0.7);
//    Server s3( &rng, n, 0.9);
//    CNEventExploder ee;
//    ee.add_handler(&s1);
//    ee.add_handler(&s2);
//    ee.add_handler(&s3);
    Server ee( &rng, n, 0.8);
    Generator gen( &ee, &rng, j);

    CNEventScheduler sched;
    sched.statistics(new CNLREF);
    double runtime = clock();
    
    sched.start( new CNEvent( EV_in, &gen, 0.0) );

    runtime = clock() - runtime;
    cout << "# runtime: "<< runtime / 1000000.0
	 <<" count: "<< sched.statistics()->trials()
	 <<" av. len: "<< sched.statistics()->mean()
	 << endl
	 << sched.statistics()->mean() <<"\t"
	 << runtime / sched.statistics()->trials() << endl;

    ofstream str("mmn.lre");
    
    sched.statistics()->print( str );
    
    delete sched.statistics();
    sched.statistics(NIL);
}
