//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDDrawing.h,v 0.31 1996-08-07 17:57:16+02 steppler Exp $
 *
 * Class: EZDDrawing --- Interface to ezd drawings
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __EZDDrawing_h
#define __EZDDrawing_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/EZD.h>		        // Base class

#include <limits.h>


extern CNClassDesc CN_EZDDRAWING;	// Class EZDDrawing description


/*
 * The class EZDDrawing
 */

class EZDDrawing : public EZD
{
  private:
    int clipx, clipy, clipwidth, clipheight;

  public:
    void set();

    /***** Constructors ******************************************************/
  public:
    EZDDrawing()                     : EZD("draw"), clipx(-1), clipy(-1),
                                       clipwidth(INT_MAX),
                                       clipheight(INT_MAX) { set(); }
    EZDDrawing(CNParam *)            : EZD("draw"), clipx(-1), clipy(-1),
                                       clipwidth(INT_MAX),
                                       clipheight(INT_MAX) { set(); }
    EZDDrawing(const CNString &name) : EZD(name), clipx(-1), clipy(-1),
                                       clipwidth(INT_MAX), 
	                               clipheight(INT_MAX) { set(); }
    EZDDrawing(const CNString &name, 
	       const int x, 
	       const int y, 
	       const int w,
	       const int h)          : EZD(name), clipx(x), clipy(y),
	                               clipwidth(w), 
	                               clipheight(h) { set(); }

    friend class EZDWindow;


    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EZDDRAWING;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EZDDRAWING ? TRUE : EZD::is_a(desc);
    };
        
    static EZDDrawing *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDDrawing *)obj;
#   else
	return (EZDDrawing *)( !obj || obj->is_a(CN_EZDDRAWING)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDDRAWING) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDDrawing(param) : new EZDDrawing; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__EZDDrawing_h**/
