//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDServer.h,v 0.30 1996-08-07 17:57:31+02 steppler Exp $
 *
 * Class: EZDServer --- Graphical representation of a server
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __EZDServer_h
#define __EZDServer_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/String.h>
#include <CNCL/EZDObject.h>		// Base class

extern CNClassDesc CN_EZDSERVER;	// Class EZDServer description


/*
 * The class EZDServer
 */

class EZDServer : public EZDObject
{
public:
    virtual void redraw();

    void color(const CNString &c) { col = c; redraw(); }

    // Private members
private:
    enum { RADIUS=20 };

    /*
     *  x _   y - rad
     *   / \
     *  |   | y
     *   \_/
     *        y + rad
     */
    int rad;
    CNString col;
    CNString txt;
    
    void initialize(int radius);
    
    /***** Constructors ******************************************************/
public:
    EZDServer()
	: col(""), txt(""), EZDObject("server", 0, 0)  { initialize(RADIUS); }
    EZDServer(CNParam *)
	: col(""), txt(""), EZDObject("server", 0, 0)  { initialize(RADIUS); }
    EZDServer(int x, int y, int radius=RADIUS)
	: col(""), txt(""), EZDObject("server", x, y)  { initialize(radius); }
    EZDServer(const CNString &name, int x, int y, int radius=RADIUS)
	: col(""), txt(""), EZDObject(name,     x, y)  { initialize(radius); }

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EZDSERVER;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EZDSERVER ? TRUE : EZDObject::is_a(desc);
    };
        
    static EZDServer *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDServer *)obj;
#   else
	return (EZDServer *)( !obj || obj->is_a(CN_EZDSERVER)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDSERVER) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDServer(param) : new EZDServer; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__EZDServer_h**/
