//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDTimer.c,v 0.30 1996-08-07 17:57:37+02 steppler Exp $
 *
 * Class: EZDTimer --- Graphical representation of Timer
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "EZDTimer.h"



/*
 * Initialize coordinates
 */
void EZDTimer::initialize(int radiusx, int radiusy)
{
  rx = radiusx;
  ry = radiusy;
    w  = 2*rx;
    h  = 2*ry;
    x1 = x()-rx;
    y1 = y()-ry;

    pie = new EZDObject(name()+"-pie", 0, 0);
  a1  = 270;  // starte in 12:00Uhr !!
    a2  = 0;
    col = "";
  active_col="";
}



/*
 * Draw Timer
 */
void EZDTimer::redraw()
{
    /* Draw frame */
    start();
    // clear inner area!
    draw_pie_arc(x1, y1, w, h,  0, 360, "white");
    draw_arc(     x1, y1, w, h, a1, 360, "");
    end();
    /* Draw pie */
    redraw_pie();
}



/*
 * Draw pie - separate object
 */
void EZDTimer::redraw_pie()
{
    pie->start();
    pie->pie_arc(left(), upper(), w, h, a1, a2, col);
    pie->end();
    EZD::pause(1);
}


/*
 * Set angle and draw pie
 */
void EZDTimer::angle(int a)
{
    a2 = a;
    redraw_pie();
}

void EZDTimer::set_angle(int a)
{
    a2 = a;
    redraw_pie();
}

void EZDTimer::offset_angle(int a)
{
  a1 = a;
  redraw_pie();
}

void EZDTimer::set_offset_angle(int a)
{
  a1 = a;
  redraw_pie();
}


/*
 * active/deactive Timer
 */
void EZDTimer::activate()
{
  draw_arc(x1-ACT_SEP, y1-ACT_SEP, w+2*ACT_SEP, h+2*ACT_SEP, 0,360,active_col);
}
void EZDTimer::deactivate()
{
  draw_arc(x1-ACT_SEP, y1-ACT_SEP, w+2*ACT_SEP, h+2*ACT_SEP, 0,360,"white");
}

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDTimer::print(ostream &strm) const
{
    // ... insert your own stuff here ...
    strm << "..." << endl;
}

// Debug output
void EZDTimer::dump(ostream &strm) const
{
    // ... insert your own stuff here ...
    strm << "EZDTimer { $Revision: 0.30 $"
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDTimer
static CNClass EZDTimer_desc("EZDTimer", "$Revision: 0.30 $",
			     EZDTimer::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDTIMER = &EZDTimer_desc;






