// -*- C++ -*-

#include <unistd.h>

#include <CNCL/String.h>

#include <CNCL/FiboG.h>
#include <CNCL/RndInt.h>

#include <CNCL/EZD.h>
#include <CNCL/EZDWindow.h>
#include <CNCL/EZDDrawing.h>

#include <CNCL/EZDDiagWin.h>


#ifndef __linux__
extern "C" int usleep(unsigned);
#endif


int main()
{
    EZDWindow win(400, 400);
    EZDDrawing draw;
    CNString in; 
    CNFiboG *g = new CNFiboG;
    CNRndInt rnd(-5, 63, g);
    int i, v;
	
    win.overlay(&draw);

    EZD::draw_fill_rectangle(50,150,300,50, "Green");

    EZDDiagWin diag("rxlev", "RXLEV Mobilstation 1", 200, 64,
		    2, "Black", "Red");
    diag.style(EZDDiagWin::HISTO);
    
    for(i=0; i<400; i++)
    {
	v = rnd();
	
	diag.add(v);
	EZD::draw_fill_rectangle(v*5, v*5, 10, 10, "Red");

	usleep(100000);
    }
    

    cin >> in;
    
}
