//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FVar.h,v 0.30 1996-08-07 17:58:21+02 steppler Exp $
 *
 * Class: CNFVar --- Fuzzy variable
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNFVar_h
#define __CNFVar_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Named.h>		// Base class
#include <CNCL/FSet.h>
#include <CNCL/ArrayObject.h>

extern CNClassDesc CN_FVAR;	// CNClass CNFVar description


/*
 * The class CNFVar
 */

class CNFVar : public CNNamed
{
  public:
    double set_value(double x);		// Set/get value
    double value(double x);
    double get_value()         const;
    double value()             const;

    CNFSet *set_fuzzy_value(CNFSet *x);	// Set/get fuzzy value
    CNFSet *fuzzy_value(CNFSet *x);
    CNFSet *get_fuzzy_value()   const;
    CNFSet *fuzzy_value()       const;

    double get_xmin()          const;	// Get xmin/xmax
    double get_xmax()          const;
    double xmin()              const;
    double xmax()              const;

    // Access to array of linguistic values
    void add_value_set(CNFSet &fset);	// Add fuzzy set
    void add_value_set(CNFSet *fset);
    void add_value_set(int i, CNFSet &fset);	
    void add_value_set(int i, CNFSet *fset);

    CNFSet *get_value_set(int i);	// Get fuzzy set [i]
    double get_membership(int i);	// Get membership for fuzzy set [i]
    					// and current value of fuzzy var
    
    // Debug functions
    void print_membership();		// Compute membership for each fuzzy
    					// and print results

  private:
    double        varvalue;		// Current value
    CNFSet       *varfvalue;		// Current fuzzy value
    double        varxmin, varxmax;	// value range
    CNArrayObject varsets;		// Affiliated fuzzy sets

    /***** Constructors ******************************************************/
  public:
    CNFVar(CNParam *param);		// CNParam constructor
    CNFVar(double min=0, double max=1);
    CNFVar(CNStringR xname, double min=0, double max=1);

    void init(CNStringR xname, double min, double max);
    
    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_FVAR;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_FVAR ? TRUE : CNObject::is_a(desc);
    };
        
    static CNFVar *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFVar *)obj;
#   else
	return (CNFVar *)( !obj || obj->is_a(CN_FVAR)
	       ? obj : fatal_type(obj->class_desc(), CN_FVAR) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFVar(param) : new CNFVar; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__CNFVar_h**/
