//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ColorfulObject.c,v 0.31 1996-08-07 17:58:29+02 steppler Exp $
 *
 * Class: ColorfulObject ---  replacement for GIST1 ColorfulObject
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include <iostream.h>
#include <strstream.h>

#include "ColorfulObject.h"

static char onamebuf[32];
static id = 0;
static char *oname() {
    ostrstream o(onamebuf, 32);
    o << "ColorfulObject_" << ++id << ends;
    return onamebuf;
};


ColorfulObject::ColorfulObject(World& w,
			       const char *picname, 
			       const char *color,
			       float x, float y, 
			       float, float,
			       double time) :
  MovingObject(w, oname())
{
    lasttime = time;
    pos = new GISTCoordAttribute(this, "Position");
    img = new GISTTextAttribute(this, "Look");
    col = new GISTTextAttribute(this, "Color");
    pic = new GISTPicture(this, "Image");
    pos->put(time, x, y);
    img->put(time, picname);
    col->put(time, color);
    pic->set_color(col);
    pic->set_pos(pos);
    pic->draw_image(img);
};

ColorfulObject::ColorfulObject(World& w,
			       const char *picname, 
			       float red, float green, float blue,
			       float x, float y, 
			       float, float,
			       double time) :
  MovingObject(w, oname())
{
    lasttime = time;
    pos = new GISTCoordAttribute(this, "Position");
    img = new GISTTextAttribute(this, "Look");
    col = new GISTTextAttribute(this, "Color");
    pic = new GISTPicture(this, "Image");
    pos->put(time, x, y);
    img->put(time, picname);
    col->put(time, pic->color_name(red, green, blue));
    pic->set_color(col);
    pic->set_pos(pos);
    pic->draw_image(img);
};

ColorfulObject::ColorfulObject(World& w,
			       const char *objectname,
			       const char *picname, 
			       const char *color,
			       float x, float y, 
			       float, float,
			       double time) :
  MovingObject(w, objectname)
{
    lasttime = time;
    pos = new GISTCoordAttribute(this, "Position");
    img = new GISTTextAttribute(this, "Look");
    col = new GISTTextAttribute(this, "Color");
    pic = new GISTPicture(this, "Image");
    pos->put(time, x, y);
    img->put(time, picname);
    col->put(time, color);
    pic->set_color(col);
    pic->set_pos(pos);
    pic->draw_image(img);
};

ColorfulObject::ColorfulObject(World& w,
			       const char *objectname,
			       const char *picname, 
			       float red, float green, float blue,
			       float x, float y, 
			       float, float,
			       double time) :
  MovingObject(w, objectname)
{
    lasttime = time;
    pos = new GISTCoordAttribute(this, "Position");
    img = new GISTTextAttribute(this, "Look");
    col = new GISTTextAttribute(this, "Color");
    pic = new GISTPicture(this, "Image");
    pos->put(time, x, y);
    img->put(time, picname);
    col->put(time, pic->color_name(red, green, blue));
    pic->set_color(col);
    pic->set_pos(pos);
    pic->draw_image(img);
};

ColorfulObject::ColorfulObject(World &w,const char *objectname) :
  MovingObject(w, objectname) {};

void ColorfulObject::move(float x, float y, double time) {
    pos->put(time, x, y);
    lasttime = time;
};

void ColorfulObject::change_look(const char *picname) {
    img->put(lasttime, picname);
};

void ColorfulObject::change_color(const char *color) {
    col->put(lasttime, color);
};

void ColorfulObject::change_color(float red, float green, float blue) {
    col->put(lasttime, pic->color_name(red, green, blue));
};


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void ColorfulObject::print(ostream &strm) const
{
    GISTObject::print(strm);
    pos->print(strm);
    img->print(strm);
    col->print(strm);
    pic->print(strm);
}

// Debug output
void ColorfulObject::dump(ostream &strm) const
{
    strm << "ColorfulObject { $Revision: 0.31 $" << endl;
    GISTObject::dump(strm);
    pos->dump(strm);
    img->dump(strm);
    col->dump(strm);
    pic->dump(strm);
    strm << " }" << endl;
}


/***** CNCL stuff for type information ***************************************/

// Describing object for class ColorfulObject
static CNClass ColorfulObject_desc("ColorfulObject", "$Revision: 0.31 $",
			    ColorfulObject::new_object);

// "Type" for type checking functions
CNClassDesc CN_COLORFULOBJECT = &ColorfulObject_desc;
