// -*- C++ -*-

// GIST -- Graphical Interactive Simulation Result Tool

//   CNCL interface classes

//   1992,93 Martin Horneffer

#ifndef gist_ivimpl_h
#define gist_ivimpl_h

#include <ctype.h>
#include <fstream.h>
#include <strstream.h>
#include "gist_impl.hh"
#include "gist_fn.hh"
#include <CNCL/Pipe.h>
#include <CNCL/SocketStream.h>

// interface to InterViews-GIST

class CommIVImpl: public CommImpl {
    long id;
    char *host_;
    unsigned short port_;
    bool abort_;
    ostream *out_;
    istream *in_;
    int fd;
    SocketStream *socket;
    CNPipe *pipe;
    ofstream *file;
  public:
    CommIVImpl(const char *host, unsigned short port, bool abort,
	       bool do_magic, long magic);
    virtual ~CommIVImpl();
    virtual int ok();
    virtual const char *gist_type();
    virtual int newid();
    virtual void send(const char*);
};

class WorldIVImpl: public GISTWorldImpl {
    int mode;
    double lasttime;
    ostrstream *str;
  public:
    long id;
    CommIVImpl *comm_;
    WorldIVImpl(CommImpl *comm, const char *name, 
		float xmin, float xmax, float ymin, float ymax, 
		double st, int m);
    virtual ~WorldIVImpl();
    virtual void flush();
    virtual void flush(double time);
    virtual void check_flush();
    virtual void check_flush(double time);
    virtual const char *gist_type();
    inline ostream& out() { return *str; };
};

class ObjectIVImpl: public GISTObjectImpl {
  public:
    long id;
    WorldIVImpl *world_;
    
    ObjectIVImpl(GISTWorldImpl *world,const char *name);
    virtual ~ObjectIVImpl() ;
    virtual const char *gist_type();
};

class AttributeIVImpl {
  public:
    long id;
    WorldIVImpl *world_;
    ObjectIVImpl *obj_;
    AttributeIVImpl(GISTObject *object);
    virtual ~AttributeIVImpl();
};
class TextAttributeIVImpl
    : public GISTTextAttributeImpl, public AttributeIVImpl {
  public:
    TextAttributeIVImpl(GISTObject *object, const char *name);
    virtual void put(double time, const char *data);
};

class ValueAttributeIVImpl
    : public GISTValueAttributeImpl, public AttributeIVImpl {
  public:
    ValueAttributeIVImpl(GISTObject *object, const char *name);
    virtual void put(double time, float data);
};

class CoordAttributeIVImpl
    : public GISTCoordAttributeImpl, public AttributeIVImpl {
  public:
    CoordAttributeIVImpl(GISTObject *object, const char *name);
    virtual void put(double time, float x, float y);
};

class ValueArrayAttributeIVImpl
    : public GISTValueArrayAttributeImpl, public AttributeIVImpl {
    unsigned short dim;
  public:
    ValueArrayAttributeIVImpl(GISTObject *object, const char *name, unsigned short arraydim);
    virtual void put(double time, const float data[]);
};

class CoordArrayAttributeIVImpl
    : public GISTCoordArrayAttributeImpl, public AttributeIVImpl {
  public:
    unsigned short dim;
    CoordArrayAttributeIVImpl(GISTObject *object, const char *name,unsigned short arraydim);
    virtual void put(double time, const float data[]);
};


class GraphicIVImpl {
    char colorbuf[80];
  public:
    long id;
    WorldIVImpl *world_;
    ObjectIVImpl *obj_;
    int byte(float);
    virtual const char *xcolor_name(float red, float green, float blue);

    GraphicIVImpl(GISTObject *object);
    virtual ~GraphicIVImpl();
};

class PictureIVImpl: public GISTPictureImpl, public GraphicIVImpl {
  public:
    PictureIVImpl(GISTObject *parent,
		  const char *name,
		  int prio,
		  GISTTextAttributeImpl *vis,
		  GISTWorldImpl *world);
    virtual const char *color_name(float red, float green, float blue);
    virtual void set_color(const char *color);
    virtual void set_color(GISTTextAttributeImpl *attr);
    virtual void set_brush(float thickness, unsigned short pattern);
    virtual void pen_down();
    virtual void pen_up();
    virtual void pen_up_fill();
    virtual void close_path();
    virtual void set_pos(float x, float y);
    virtual void set_pos(GISTCoordAttributeImpl *attr,int);
    virtual void set_path(GISTCoordArrayAttributeImpl *attr,int);
    virtual void move_rel(float dx, float dy);
    virtual void move_rel(float dx, GISTValueAttributeImpl *dy,int);
    virtual void move_rel(GISTValueAttributeImpl *dx,float dy,int);
    virtual void move_rel(GISTValueAttributeImpl *dx,GISTValueAttributeImpl *dy,int);
    virtual void move_dir(float dx, GISTValueAttributeImpl *dy,int);
    virtual void move_dir(GISTValueAttributeImpl *dx,float dy,int);
    virtual void move_dir(GISTValueAttributeImpl *dx,GISTValueAttributeImpl *dy,int);
    virtual void polyline(GISTCoordArrayAttributeImpl*,int);
    virtual void polygon(GISTCoordArrayAttributeImpl*,int);
    virtual void text(const char *text,float size,const char *font,const char *style);
    virtual void text(GISTTextAttributeImpl *text,float size,const char *font,const char *style);
    virtual void text(GISTValueAttributeImpl *text,float size,int steadiness,int precision,long flags,const char *font,const char *style);
    virtual void draw_image(const char *name,float x_align,float y_align);
    virtual void draw_image(GISTTextAttributeImpl *name,float x_align, float y_align);
};

class ImageIVImpl: public GISTGraphicImpl, public GraphicIVImpl {
  public:
    virtual const char *color_name(float red, float green, float blue);
    ImageIVImpl(GISTObject *parent,
		const char *name,
		const char *image, 
		float x, float y,
		float width, float height,
		float hcenter, float vcenter,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world,
		float minsize);
    ImageIVImpl(GISTObject *parent,
		const char *name,
		const char *image, 
		GISTCoordAttributeImpl *position,
		float width, float height,
		float hcenter, float vcenter,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world,
		int steadiness,
		float minsize);
    ImageIVImpl(GISTObject *parent,
		const char *name,
		GISTTextAttributeImpl *image, 
		float x, float y,
		float width, float height,
		float hcenter, float vcenter,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world,
		float minsize);
    ImageIVImpl(GISTObject *parent,
		const char *name,
		GISTTextAttributeImpl *image, 
		GISTCoordAttributeImpl *position,
		float width, float height,
		float hcenter, float vcenter,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world,
		int steadiness,
		float minsize);
};

class CurveIVImpl: public GISTGraphicImpl, public GraphicIVImpl {
  public:
    virtual const char *color_name(float red, float green, float blue);
    CurveIVImpl(GISTObject *parent,
		const char *name,
		GISTValueAttributeImpl *value, 
		float x, float y, int type,
		float width, float height,
		float hcenter, float vcenter,
		const char *foreg, const char *backg,
		int prio,
		GISTTextAttributeImpl *vis,
		GISTWorldImpl *world,
		float minsize);
    virtual void hint(const char*text);
};

class DiagramIVImpl: public GISTGraphicImpl, public GraphicIVImpl {
  public:
    virtual const char *color_name(float red, float green, float blue);
    DiagramIVImpl(GISTObject *parent,
		  const char *name,
		  GISTCoordArrayAttributeImpl *value, 
		  float x, float y, int type,
		  float width, float height,
		  float hcenter, float vcenter,
		  const char *foreg, const char *backg,
		  int prio,
		  GISTTextAttributeImpl *vis,
		  GISTWorldImpl *world,
		  float minsize);
    virtual void hint(const char*text);
};


#endif 
