//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: minmax.h,v 0.31 1996-08-07 17:54:32+02 steppler Exp $
 *
 * min(), max() functions header file
 *
 *****************************************************************************/

/*
Copyright (C) 1992 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _minmax_h
#define _minmax_h 1

#ifdef __GNUG__
# include <_G_config.h>
# ifdef  _G_BROKEN_SIGNED_CHAR
#  ifndef CNCL_BROKEN_SIGNED_CHAR
#   define CNCL_BROKEN_SIGNED_CHAR 1
#  endif
# endif
#endif


/*
 * CNmin()
 */
inline char CNmin(char a, char b)
{ return (a < b) ? a : b; }
#ifndef CNCL_BROKEN_SIGNED_CHAR
inline signed char CNmin(signed char a, signed char b)
{ return (a < b) ? a : b; }
#endif
inline unsigned char CNmin(unsigned char a, unsigned char b)
{ return (a < b) ? a : b; }
inline short CNmin(short a, short b)
{ return (a < b) ? a : b; }
inline unsigned short CNmin(unsigned short a, unsigned short b)
{ return (a < b) ? a : b; }
inline int CNmin(int a, int b)
{ return (a < b) ? a : b; }
inline unsigned int CNmin(unsigned int a, unsigned int b)
{ return (a < b) ? a : b; }
inline long CNmin(long a, long b)
{ return (a < b) ? a : b; }
inline unsigned long CNmin(unsigned long a, unsigned long b)
{ return (a < b) ? a : b; }
inline float CNmin(float a, float b)
{ return (a < b) ? a : b; }
inline double CNmin(double a, double b)
{ return (a < b) ? a : b; }


/*
 * CNmax()
 */
inline char CNmax(char a, char b)
{ return (a > b) ? a : b;}
#ifndef  CNCL_BROKEN_SIGNED_CHAR
inline signed char CNmax(signed char a, signed char b)
{ return (a > b) ? a : b;}
#endif
inline unsigned char CNmax(unsigned char a, unsigned char b)
{ return (a > b) ? a : b;}
inline short CNmax(short a, short b)
{ return (a > b) ? a : b;}
inline unsigned short CNmax(unsigned short a, unsigned short b)
{ return (a > b) ? a : b;}
inline int CNmax(int a, int b)
{ return (a > b) ? a : b;}
inline unsigned int CNmax(unsigned int a, unsigned int b)
{ return (a > b) ? a : b;}
inline long CNmax(long a, long b)
{ return (a > b) ? a : b;}
inline unsigned long CNmax(unsigned long a, unsigned long b)
{ return (a > b) ? a : b;}
inline float CNmax(float a, float b)
{ return (a > b) ? a : b;}
inline double CNmax(double a, double b)
{ return (a > b) ? a : b;}


/*
 * CNabs()
 */
inline char   CNabs(char   a)
{ return a < 0 ? -a : a; }
inline short  CNabs(short  a)
{ return a < 0 ? -a : a; }
inline int    CNabs(int    a)
{ return a < 0 ? -a : a; }
inline long   CNabs(long   a)
{ return a < 0 ? -a : a; }
inline float  CNabs(float  a)
{ return a < 0 ? -a : a; }
inline double CNabs(double a)
{ return a < 0 ? -a : a; }

#endif /**_minmax_h**/
