//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Double.c,v 0.30 1996-08-07 17:58:59+02 steppler Exp $
 *
 * Class: CNDouble --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "Double.h"






/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNDouble::print(ostream &strm) const
{
    strm << value;
}

// Debug output
void CNDouble::dump(ostream &strm) const
{
    strm << "CNDouble { $Revision: 0.30 $ ..."
	 << " }" << endl;
    strm << value << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNDouble
static CNClass CNDouble_desc("CNDouble", "$Revision: 0.30 $",
			    CNDouble::new_object);

// "Type" for type checking functions
CNClassDesc CN_DOUBLE = &CNDouble_desc;
