//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Double.h,v 0.30 1996-08-07 17:59:00+02 steppler Exp $
 *
 * Class: CNDouble --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNDouble_h
#define __CNDouble_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_DOUBLE;	// Class CNDouble description


/*
 * The class CNDouble
 */

class CNDouble : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNDouble(double n=0.0):value(n) {}		// Default constructor
    CNDouble(CNParam *) {}			// CNParam constructor

  public:	/***** Public interface **************************************/
    operator double() { return value; }

    double operator -() { return value = -value; } 
    double operator +() { return value; }

    double operator +=(double n) { return value += n; }
    double operator -=(double n) { return value -= n; }
    double operator *=(double n) { return value *= n; }
    double operator /=(double n) { return value /= n; }

  protected:	/***** Internal private members ******************************/
    double value;	// that's what all is about


  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_DOUBLE; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_DOUBLE ? TRUE : CNObject::is_a(desc); }
        
    static CNDouble *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDouble *)obj;
#   else
	return (CNDouble *)( !obj || obj->is_a(CN_DOUBLE)
	       ? obj : fatal_type(obj->class_desc(), CN_DOUBLE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDouble(param) : new CNDouble; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNDouble_h**/
