//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: IniFile.h,v 0.31 1996-08-07 17:59:13+02 steppler Exp $
 *
 * Class: CNIniFile --- .ini-style config file
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNIniFile_h
#define __CNIniFile_h


#include <CNCL/Named.h>		// Base class
#include <CNCL/DLList.h>
#include <CNCL/DLIterator.h>


extern CNClassDesc CN_INIFILE;	// Class CNIniFile description


/*
 * The class CNIniFile
 */

class CNIniFile : public CNNamed
{
  public:	/***** Constructors ******************************************/
    CNIniFile();
    CNIniFile(CNParam *);
    CNIniFile(CNStringR name);
    ~CNIniFile();
    
  public:	/***** Public interface **************************************/
    int read();
    int read(CNStringR name);
    int write();
    int write(CNStringR name);

    CNStringR get_entry(CNStringR section, CNStringR name, bool first=TRUE);
    CNStringR get_entry(CNStringR name, bool first=TRUE);
    double    get_double(CNStringR section, CNStringR name, bool first=TRUE);
    double    get_double(CNStringR name, bool first=TRUE);
    int       get_int(CNStringR section, CNStringR name, bool first=TRUE);
    int       get_int(CNStringR name, bool first=TRUE);
    bool      test_entry(CNStringR section, CNStringR name);
    bool      test_entry(CNStringR name, bool first=TRUE);
    CNStringR get_section();
    void      set_section(CNStringR section);
    

  private:	/***** Internal private members ******************************/
    CNString     ini_section;
    CNDLList     ini_list;
    CNDLIterator ini_trav, ini_sec;
    

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_INIFILE; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_INIFILE ? TRUE : CNNamed::is_a(desc); }
        
    static CNIniFile *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNIniFile *)obj;
#   else
	return (CNIniFile *)( !obj || obj->is_a(CN_INIFILE)
	       ? obj : fatal_type(obj->class_desc(), CN_INIFILE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNIniFile(param) : new CNIniFile; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump(ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNIniFile &obj);
ostream &operator << (ostream &strm, const CNIniFile *obj);

#endif /**__CNIniFile_h**/
