//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ParseArgs.c,v 1.2 1996-08-07 17:59:21+02 steppler Exp $
 *
 * Class: CNParseArgs --- Argument Parser
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 *****************************************************************************/

#include <CNCL/Class.h>

#include <string.h>
#include "ParseArgs.h"

//static int count_default = 0;

// CNParseArgs * CNParseArgs::actual_ParseArgsObj = NIL;

static void check_blank_handling (CNParseArgsList &args_list) {
   // Syntax check for NO_BLANK options. Checks if a NO_BLANK argument
   // string is contained as the prefix of any other string. If yes
   // reports the error and exits. Otherwise returns to calling
   // function. 
   int no_blank_option_length; // Length of option_string with NO_BLANK
                               // processing  
   for (int loop = 0; loop < args_list.number_of_args; loop++) {
      if (args_list.args_array[loop].blank == NO_BLANK) {
	 for (int count = 0; count < args_list.number_of_args; count++){ 
	    if (count != loop) {
	       no_blank_option_length =
		  strlen(args_list.args_array[loop].option_string); 
	       // Compare NO_BLANK string (index loop) with other
	       // option string (index count)
	       if (strncmp(args_list.args_array[loop].option_string ,
		       args_list.args_array[count].option_string,
		       no_blank_option_length) == 0) {
		  cout << "Error, conflict in option specification:\n"
		     << " NO_BLANK specifification in option: `" <<
		     args_list.args_array[loop].option_string << 
		     "'\n conflicts with option: `" <<
		     args_list.args_array[count].option_string <<
		     "'.\n Exiting!" << endl; 
		  exit(-1);
	       }
	    }
         }
      }
   }
}

static void check_parameters (CNParseArgsList &args_list ) {
   // checks the given parameters (mandatory,positional)
   if (args_list.mandatory_args > args_list.number_of_args) {
      cout << "Error, the number of 'mandatorial' is bigger"
           << "\nthan the given list of arguments ! Exiting !\n";
      exit(-1);
   }
   if (args_list.positional_args > args_list.number_of_args) {
      cout << "Error, the number of 'positional' is bigger"
           << "\nthan the given list of arguments ! Exiting !\n";
      exit(-1);
   }   
}


static int option_position (char * option, CNParseArgsList &args_list) {
   
   // gives the option's position back in arg_desc[]      
   for (int loop = 0; loop < args_list.number_of_args; loop++ ) {
       if (strcmp(option,args_list.args_array[loop].option_string)
             == 0) {  
             // compares the given option with the option list      
             return (loop);
       }
   }
   cout << "Error, option `" << option
        << "' does not exist\nin the option list !  Exiting !" << endl;
   exit(-1);
}


static int next_is_option (int pos, int argc, char **argv) {
   //returns true, if the next element behind pos in the argv-string
   //is an option or if the actual element is the last one in the argv-string

   if (pos + 1 < argc) {
      //make sure that this is not the last element
      if (argv[pos+1][0] == '-' && argv[pos+1][1] != '-') {
	 return (1);
      }
      else {
	 return (0);
      }
   }
   else {
      return (1);
   }
}



static BlankHandling option_with_blank (char * option, int argc, char **argv,
                                  int pos, CNParseArgsList &args_list) {
   // gives back BLANK or NO_BLANK
   // if it is a NO_BLANK then copies the argument
   // in args_..argument_string
   int arg_length = strlen(option);
    
   for (int loop = 0; loop < args_list.number_of_args; loop++) {
      int option_length = 
          strlen(args_list.args_array[loop].option_string);

      if (strncmp(args_list.args_array[loop].option_string,
		  option,option_length) == 0 && 
	  args_list.args_array[loop].blank == NO_BLANK) {
	  // The option string equals the NO_BLANK option `loop'
	  // If there are more characters in option, they are the
	  // argument
	  if (arg_length > option_length) {
	      // assign argument
	      args_list.args_array[loop].argument_string =
		  option + option_length;
	  } else {
	      // assign default
	    args_list.args_array[loop].argument_string =
		args_list.args_array[loop].default_argument;
	  }

	  if ((strcmp(args_list.args_array[loop].option_string,
		    option) == 0) && !(next_is_option(pos, argc, argv))) {
	    cout << "Attention, the option '"
		 << option << "' and its argument "
	       "\nhave to be given without white space"
	       " character !\nExiting !\n";
	    exit(-1);
	 }
// The following is wrong: A correctly recognized NO_BLANK argument was
// overriden with the default. 
// 	 if (next_is_option(pos, argc, argv)) {
// 	    args_list.args_array[loop].argument_string =
// 		args_list.args_array[loop].default_argument;
// //		CNParseArgs::empty_string;  
//	 }
	 return (NO_BLANK);
      }
   }
   return (BLANK);  
}


static void assign_args_strings (int argc, char **argv,
				 CNParseArgsList &args_list) {
   // Parse arguments that are given in `args_list' and assign the
   // appropriate pointers to `argument_string' member of
   // `args_list....'  

   char * new_option = NIL; 
   // pointer to actual option string
   // NIL if argument is positional
   int position = 0; // position of the argument in args_list
   int offset = 0;
   int already_set_pos = 0;
   // # of positional arguments which already have been parsed
    
   for (int loop = 1; loop < argc; loop++) {
      if (argv[loop][0] == '-' && argv[loop][1] != '-') {
         // is an option
         if (new_option == NIL) { // checks for separate option
            new_option = argv[loop] + 1; 
      	    if (*new_option == '\0') { 
               // checks for separate '-'
	       cout << "Error in arguments: Separate - character"
		  " is not allowed!" << endl;
	       exit(-2); 
            }  
            if (option_with_blank(new_option, argc, argv, loop, args_list) 
                == BLANK) {  // option with blank
	       position = option_position(new_option, args_list);
	       if (next_is_option(loop, argc, argv)){
		  // option switch without argument => argument set to 
		  // white space
		  args_list.args_array[position].argument_string =
		      args_list.args_array[position].default_argument;
//		      CNParseArgs::empty_string;   
		  new_option = NIL;
	       }
	       else {}
            } else {       // option with NO_BLANK
	       new_option = NIL;
	    } 
	 }
      } else {  // is an argument 
         if (argv[loop][1] == '-') {
	    offset = 1; // skip first '-' used as escape character 
	 }
	 
         if (new_option != NIL) {  // argument with option
            new_option = NIL;
         } else {  // argument without option
	    if (already_set_pos < args_list.positional_args) {
	       //it's allowed to set arguments without option switch
	       position = already_set_pos;
	       already_set_pos++;
	    } else {
	       // # of arguments given as positional is bigger than allowed
	       cout << "Attention !\nOnly the " 
		    << args_list.positional_args 
		    << " argument(s) can be given without switch !"
                    << " \nExiting ! " << endl; 
	       exit(-1);
	    }
	 }  
	 args_list.args_array[position].argument_string = argv[loop] + offset;
	 new_option = NIL;
         offset = 0;        
      }
   }
}


static void init_arguments_list(CNParseArgsList &args_list) {
   // initialise all arguments to defaults before processing argv[]
   for (int loop = 0; loop < args_list.mandatory_args; loop++) {
      // checks the mandatorial arguments
      if (args_list.args_array[loop].default_argument != NIL) {
	 cout << "Invalid default specification for mandatory"
	    " argument\n`" << args_list.args_array[loop].option_string   
	      << " given!\nExiting!" << endl;
	 exit(-1);
      }
   }
   for (int count = args_list.mandatory_args; 
	count < args_list.number_of_args; count++) { 
      // initialize argument pointers with defaults given in args_list
       args_list.args_array[count].argument_string = NIL;
//	 = args_list.args_array[count].default_argument;

   }
}


static void check_mandatorial (CNParseArgsList &args_list) {
   // check if all mandatorial arguments are given
   for (int loop = 0;loop < args_list.mandatory_args; loop++) {
      if (args_list.args_array[loop].argument_string == NIL) {
	 cout << "The first " << args_list.mandatory_args
	      << " Argument(s) have to be given!" << endl
	      << "Exiting !\n";
	 exit(-1);
      }
   }
}


void CNParseArgs::usage_screen(char * prog_name, CNParseArgsList &args_list) {
   int c_man = args_list.mandatory_args;   // count mandatory 
   int c_pos = args_list.positional_args;  // count positional
       
   // gives the usage of args_list 
   cout << "usage   : " << prog_name ; 
   for (int loop1 = 0; loop1 < args_list.number_of_args; loop1++) {
      cout << " ";
      if (c_man <= 0) cout << "[";
      if (c_pos > 0) cout << "[";
      cout << "-" << args_list.args_array[loop1].option_string;
      if (c_pos > 0) cout << "]" ;

      if (args_list.args_array[loop1].blank == BLANK) {
	 cout << " ";
      }
      if (args_list.args_array[loop1].default_argument != NIL
	  || loop1 >= args_list.mandatory_args) {
         cout << "[<" << args_list.args_array[loop1].option_string << ">]";
      } else {
	 cout << "<" << args_list.args_array[loop1].option_string << ">";
      }

      if (c_man <= 0) cout << "]";
      c_man--;
      c_pos--;
   }

   cout << endl;
   for (int loop3 = 0; loop3 < args_list.number_of_args; loop3++) {
      cout << " " 
           << args_list.args_array[loop3].option_string 
           << "  : "  
           << args_list.args_array[loop3].usage << endl;
   }
   cout << endl;
}


//const  char * const CNParseArgs::empty_string = "";


/****************** Member functions of class CNParseArgs ******************/


/****** Constructor *******/

CNParseArgs::CNParseArgs(int argc, char **argv, CNParseArgsList
 &args_list) : number_args(argc), args_ptr(( const char ** )argv),
  option_list(&args_list) { 

    check_blank_handling(args_list);

    check_parameters(args_list);

    init_arguments_list(args_list);
 
    // if no arguments are specified but at least one is mandatory ->
    // give out usage text      
    if (argc <= 1 && args_list.mandatory_args > 0) { 
       if (args_list.usage_func == NIL) {
	   // Take own function
           usage_screen(argv[0], args_list);
	   exit(-1);
       } else {
	   // Take user supplied function
           args_list.usage_func(argc, argv);
       }
    }     

    assign_args_strings(argc, argv, args_list);
    check_mandatorial(args_list);
}

CNParseArgs::CNParseArgs()
    : number_args(0),
      args_ptr(NIL),
      option_list(NIL)
{}

CNParseArgs::CNParseArgs(CNParam*)
    : number_args(0),
      args_ptr(NIL),
      option_list(NIL)
{}

void CNParseArgs::override_nil(int first_arg, int last_arg /* = 0 */) {
// Function to override NIL argument pointers by pointer to default
    if (0 > first_arg || first_arg >= option_list->number_of_args ||
	(0 != last_arg && last_arg < first_arg) )
    {
	cout << "Invalid arguments specified in call to"
	    " CNParseArgs::override_nil(), exiting!\n";
    }
    if (0 == last_arg) { 
	if (NIL == option_list->args_array[first_arg].argument_string) {
	    option_list->args_array[first_arg].argument_string = 
		option_list->args_array[first_arg].default_argument;
	}
    } else {
	for (; first_arg <= last_arg; first_arg++) {
	    if (NIL == option_list->args_array[first_arg].argument_string) {
		option_list->args_array[first_arg].argument_string = 
		    option_list->args_array[first_arg].default_argument;
	    }
	}
    }
    return;
}

char * CNParseArgs::operator[](int index) {
    // returns a pointer to the argument string number `index'
    if (index < 0 || index >= option_list->number_of_args) 
    {
	cout << "Error in CNParseArgs::operator[], index value: "
	     << index << " out of range.\n  Valid range: [0 .. "
	     << option_list->number_of_args << "]. Exiting!\n"
	     << endl;
	exit(-1);
    }
    return option_list->args_array[index].argument_string;
}

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNParseArgs::print(ostream &strm) const
{
    strm << "..." << endl;
}

// Debug output
void CNParseArgs::dump(ostream &strm) const
{
    strm << "CNParseArgs { $Revision: 1.2 $ ..."
	 << " }" << endl;
}

// IOStream operator <<
ostream &operator << (ostream &strm, const CNParseArgs &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNParseArgs *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNParseArgs
static CNClass CNParseArgs_desc("CNParseArgs", "$Revision: 1.2 $",
			    CNParseArgs::new_object);

// "Type" for type checking functions
CNClassDesc CN_PARSEARGS = &CNParseArgs_desc;
