//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Ptr.h,v 1.3 1996-08-07 17:59:27+02 steppler Exp $
 *
 * Class: CNPtr --- Intelligent pointer to CNRefObjs
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNPtr_h
#define __CNPtr_h


#include <CNCL/Object.h>		// Base class
#include <CNCL/RefObj.h>

extern CNClassDesc CN_PTR;	// Class CNPtr description


/*
 * The class CNPtr
 */

class CNPtr : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNPtr()            	  : obj(NIL) {}
    CNPtr(CNParam *)   	  : obj(NIL) {}
   
    CNPtr(CNRefObj *o) 	  : obj(o)   {}
    CNPtr(const CNPtr &p) : obj(p.obj) { if(obj) obj->ref(); }

    virtual ~CNPtr() { if(obj) obj->deref(); }
    
  public:	/***** Public interface **************************************/
    CNPtr &operator = (const CNPtr &p)
    {
	if(obj) obj->deref();
	obj = p.obj;
	if(obj) obj->ref();
	return *this;
    }

    CNRefObj *operator -> () const
    {
	return obj;
    }
    
    CNRefObj *get_object() const
    {
	return obj;
    }

  private:	/***** Internal private members ******************************/
    CNRefObj *obj;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_PTR; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_PTR ? TRUE : CNObject::is_a(desc); }
        
    static CNPtr *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNPtr *)obj;
#   else
	return (CNPtr *)( !obj || obj->is_a(CN_PTR)
	       ? obj : fatal_type(obj->class_desc(), CN_PTR) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNPtr(param) : new CNPtr; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

ostream &operator << (ostream &strm, const CNPtr &obj);
ostream &operator << (ostream &strm, const CNPtr *obj);

#endif /**__CNPtr_h**/
