//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Ref.h,v 1.4 1996-08-07 17:59:30+02 steppler Exp $
 *
 * Class: CNRef --- Base class for classes with reference counting
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNRef_h
#define __CNRef_h

/*
 * The class CNRef
 */

class CNRef
{
  public:	/***** Constructors ******************************************/
    CNRef();

  protected:
    virtual ~CNRef() {}			// protected: no automatic objects
    CNRef(const CNRef &);		// no copying of CNRefs
    CNRef &operator = (const CNRef &);
    
  public:	/***** Public interface **************************************/
    void ref();
    void deref();
    void decrease();

    static void ref(CNRef* aRef);
    static void deref(CNRef* aRef);
    static void decrease(CNRef* aRef);
    static void del(CNRef* aRef);
    
    unsigned long get_count() const;
    
    static void set_debug(bool r, bool l = FALSE);

  private:	/***** Internal private members ******************************/
    unsigned long ref_count;

    static bool debug_ref;		// Debug: ref()/deref() calls
    static bool debug_list;		// Debug: list of allocated objs
};

#endif /**__CNRef_h**/
