#include <stdio.h>
#include <stdlib.h>

#include <CNCL/GetOpt.h>

#define PROGRAM "tGetOpt"
#define VERSION "0.0"

/*
 * Usage messages
 */
void short_usage()
{
    fprintf(stderr, "usage: %s [-options] Z:N/F.P file ...\n", PROGRAM);
    fprintf(stderr, "       %s --help  for more information\n", PROGRAM);
    exit(1);
}


void usage()
{
    fprintf(stderr, "FIDOGATE %s  %s %s\n\n",
	    "0.0", PROGRAM, VERSION );
    
    fprintf(stderr, "usage:   %s [-options] Z:N/F.P file ...\n\n", PROGRAM);
    fprintf(stderr, "\
options:  -B --binkley NAME            set Binkley-style outbound directory\n\
          -F --flavor NAME             Hold | Normal | Direct | Crash\n\
\n\
          -v --verbose                 more verbose\n\
	  -h --help                    this help\n\
          -c --config name             read config file (\"\" = none)\n\
	  -L --lib-dir name            set lib directory\n\
	  -S --spool-dir name          set spool directory\n\
	  -a --addr Z:N/F.P            set FTN address\n\
	  -f --fake-addr Z:N/F.P       set FTN fakenet address\n\
	  -u --uplink-addr Z:N/F.P     set FTN uplink address\n\
          -z --zone Z                  select aka for zone Z\n"  );

    exit(0);
}



/***** main() ****************************************************************/

int main(int argc, char *argv[])
{
    int c;

    char *B_flag=NULL;
    char *F_flag="Hold";
    char *c_flag=NULL;
    char *S_flag=NULL, *L_flag=NULL;
    char *a_flag=NULL, *f_flag=NULL, *u_flag=NULL;
    char *z_flag=NULL;
    int verbose;
    
//     CNGetOpt::option long_options[] =
//     {
// 	{ "binkley",      1, 0, 'B'},	/* Binkley outbound base dir */
// 	{ "flavor",       1, 0, 'F'},	/* Outbound flavor */

// 	{ "verbose",      0, 0, 'v'},	/* More verbose */
// 	{ "help",         0, 0, 'h'},	/* Help */
// 	{ "config",       1, 0, 'c'},	/* Config file */
// 	{ "spool-dir",    1, 0, 'S'},	/* Set FIDOGATE spool directory */
// 	{ "lib-dir",      1, 0, 'L'},	/* Set FIDOGATE lib directory */
// 	{ "addr",         1, 0, 'a'},	/* Set FIDO address */
// 	{ "fake-addr",    1, 0, 'f'},	/* Set FIDO fakenet address */
// 	{ "uplink-addr",  1, 0, 'u'},	/* Set FIDO uplink address */
// 	{ "zone",         1, 0, 'z'},	/* Select aka for zone */
// 	{ 0,              0, 0, 0  }
//     };

    CNGetOpt opt;

    opt.set_args(argc, argv);
    opt.set_char_options("B:F:vhc:S:L:a:f:u:z:");
//    opt.set_long_options(long_options);
    opt.add_long_option("help",    CNGetOpt::NOPARAM, 'h');
    opt.add_long_option("binkley", CNGetOpt::WPARAM , 'B');
    
    while((c = opt()) != EOF)
	switch (c) {
	case 'B':
	    B_flag = opt.optarg();
	    break;
	case 'F':
	    F_flag = opt.optarg();
	    break;

	/***** Common options *****/
	case 'v':
	    verbose++;
	    break;
	case 'h':
	    usage();
	    break;
	case 'c':
	    c_flag = opt.optarg();
	    break;
	case 'S':
	    S_flag = opt.optarg();
	    break;
	case 'L':
	    L_flag = opt.optarg();
	    break;
	case 'a':
	    a_flag = opt.optarg();
	    break;
	case 'f':
	    f_flag = opt.optarg();
	    break;
	case 'u':
	    u_flag = opt.optarg();
	    break;
	case 'z':
	    z_flag = opt.optarg();
	    break;
	default:
	    short_usage();
	    break;
	}

    cout << "-B: " << B_flag << endl;
    cout << "-F: " << F_flag << endl;
    cout << "-v: " << verbose << endl;
    
    for(int i=opt.optind(); i<argc; i++)
	cout << "Arg[" << i << "]: " << argv[i] << endl;
    
    exit(0);
}
