//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Pstream.h,v 0.30 1996-08-07 18:00:13+02 steppler Exp $
 *
 * Class: CNPstream --- abstract base class for persistent stream classes
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNPstream_h
#define __CNPstream_h

#include <CNCL/Object.h>		// Base class

#include <CNCL/Class.h>
#include <CNCL/Param.h>


extern CNClassDesc CN_PSTREAM;	// Class CNPstream description


/*
 * The class CNPstream
 */

class CNPstream : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNPstream() {}			// Default constructor
    CNPstream(CNParam *) {}			// CNParam constructor

  public:	/***** Public interface **************************************/
    virtual CNPstream& operator<<(const char*)=0;
    virtual CNPstream& operator<<(char)=0;
    virtual CNPstream& operator<<(long)=0;
    virtual CNPstream& operator<<(double)=0;


    virtual CNPstream& operator>>(char*)=0;
    virtual CNPstream& operator>>(char&)=0;
    virtual CNPstream& operator>>(long&)=0;
    virtual CNPstream& operator>>(double&)=0;

    virtual CNPstream& getline(char*, int)=0;
    
  private:	/***** Internal private members ******************************/

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_PSTREAM; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_PSTREAM ? TRUE : CNObject::is_a(desc); }
        
    static CNPstream *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNPstream *)obj;
#   else
	return (CNPstream *)( !obj || obj->is_a(CN_PSTREAM)
	       ? obj : fatal_type(obj->class_desc(), CN_PSTREAM) );
#   endif
    }
    
};

#endif /**__CNPstream_h**/


