//    -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ReaderTbl.c,v 0.30 1996-08-07 18:00:14+02 steppler Exp $
 *
 * Class: CNReaderTbl --- Table for adress of reader-function (persistent IO)
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "ReaderTbl.h"
#include <iostream.h>

CNHashDynamic CNReaderTbl::table;	        // static members
CNHashDynamic CNReaderTbl::id_table;


CNReaderTbl::CNReaderTbl(char* classname, Reader_ptr reader_ptr)
{
    if(table.get_key(CNKeyString(classname)) == NIL)
	table.store_key(new CNKeyString(classname, (CNObject*)reader_ptr));
}

Reader_ptr CNReaderTbl::reader_ptr_by_classname(char* classname)
{
    if(table.get_key(CNKeyString(classname)) == NIL)
	fatal(NIL, "reader_ptr_by_classname() called for non-persistent ",                              classname);
              // fatal error if the classname is not found in the table
    
	return (Reader_ptr)table.get_object(new CNKeyString(classname));
}

bool CNReaderTbl::is_in(long id_key)
{
    if(id_table.get_key(CNKeyInt(id_key)) == NIL)
	return FALSE;
    return TRUE;
}

void CNReaderTbl::add_to_id_tbl(long id_key, CNObject* obj)
{ 
    id_table.store_key(new CNKeyInt((long unsigned)id_key, obj));
}

void CNReaderTbl::add_to_id_tbl(long id_key, CNObject& obj)
{
    add_to_id_tbl(id_key, &obj);
}


CNObject* CNReaderTbl::get_from_id_tbl(long id_key)
{
    return id_table.get_object(new CNKeyInt(id_key));
}

void CNReaderTbl::reset_id_tbl()
{
    id_table.reset_absolutely();
}
