//    -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Beta.c,v 0.30 1996-08-07 18:00:42+02 steppler Exp $
 *
 * CNClass: CNBeta --- CNBeta distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "Beta.h"



CNBeta::CNBeta(long a, long b, CNRNG *gen) : CNRandom(gen)
{
    assert((a>=0) && (b>=0) && ((a!=0) || (b!=0)));
    pr1 = a;
    pr2 = b;
}

CNBeta::CNBeta () : CNRandom((CNRNG*)NIL)
{
    pr1 = 0;
    pr2 = 0;
}


CNBeta::CNBeta (CNParam *) : CNRandom((CNRNG*)NIL)
{
    pr1 = 0;
    pr2 = 0;
}



double CNBeta::operator()()
{
    double proda = 1.0, prodb = 1.0;
    double tmp;
    long i;
    
    for (i = 0; i < pr1; i++ )
    {
	while ( !( tmp = pGenerator -> as_double() ) );
	proda *= tmp;
    }
    
    for (i = 0; i < pr2; i++ )
    {
	while ( !( tmp = pGenerator -> as_double() ) );
	prodb *= tmp;
    }
    
    tmp = -log( proda );
    return( tmp / ( tmp - log( prodb ) ) );
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNBeta::print(ostream &strm) const
{
    strm << "pr1=" << pr1 << " pr2=" << pr2 << endl;
}

// Debug output
void CNBeta::dump(ostream &strm) const
{
    strm << "CNBeta { "
	 << "pr1=" << pr1 << " pr2=" << pr2
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNBeta
static CNClass CNBeta_desc("CNBeta", "$Revision: 0.30 $", CNBeta::new_object);

// "Type" for type checking functions
CNClassDesc CN_BETA = &CNBeta_desc;







